/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.spi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class AllowableActions {
    public static final String CAN_GET_DESCENDENTS = "canGetDescendents";
    public static final String CAN_GET_FOLDER_TREE = "canGetFolderTree";
    public static final String CAN_GET_CHILDREN = "canGetChildren";
    public static final String CAN_GET_OBJECT_PARENTS = "canGetObjectParents";
    public static final String CAN_GET_FOLDER_PARENT = "canGetFolderParent";
    public static final String CAN_CREATE_DOCUMENT = "canCreateDocument";
    public static final String CAN_CREATE_FOLDER = "canCreateFolder";
    public static final String CAN_CREATE_RELATIONSHIP = "canCreateRelationship";
    public static final String CAN_GET_PROPERTIES = "canGetProperties";
    public static final String CAN_GET_CONTENT_STREAM = "canGetContentStream";
    public static final String CAN_UPDATE_PROPERTIES = "canUpdateProperties";
    public static final String CAN_MOVE_OBJECT = "canMoveObject";
    public static final String CAN_DELETE = "canDelete";
    public static final String CAN_DELETE_TREE = "canDeleteTree";
    public static final String CAN_SET_CONTENT_STREAM = "canSetContentStream";
    public static final String CAN_DELETE_CONTENT_STREAM = "canDeleteContentStream";
    public static final String CAN_GET_RENDITIONS = "canRenditions";
    public static final String CAN_ADD_TO_FOLDER = "canAddToFolder";
    public static final String CAN_REMOVE_OBJECT_FROM_FOLDER = "canRemoveObjectFromFolder";
    public static final String CAN_CHECKOUT = "canCheckout";
    public static final String CAN_CANCEL_CHECKOUT = "canCancelCheckout";
    public static final String CAN_CHECKIN = "canCheckin";
    public static final String CAN_GET_ALL_VERSIONS = "canGetAllVersions";
    public static final String CAN_GET_OBJECT_RELATIONSHIPS = "canGetObjectRelationships";
    public static final String CAN_ADD_POLICY = "canAddPolicy";
    public static final String CAN_REMOVE_POLICY = "canRemovePolicy";
    public static final String CAN_GET_APPLIED_POLICIES = "canGetAppliedPolicies";
    public static final String CAN_GET_ACL = "canGetACL";
    public static final String CAN_APPLY_ACL = "canApplyACL";
    public static final Collection<String> DEFAULT = Collections.unmodifiableCollection(Arrays.asList("canGetDescendents", "canGetFolderTree", "canGetChildren", "canGetObjectParents", "canGetFolderParent", "canCreateDocument", "canCreateFolder", "canCreateRelationship", "canGetProperties", "canGetContentStream", "canUpdateProperties", "canMoveObject", "canDelete", "canDeleteTree", "canSetContentStream", "canDeleteContentStream", "canRenditions", "canAddToFolder", "canRemoveObjectFromFolder", "canCheckout", "canCancelCheckout", "canCheckin", "canGetAllVersions", "canGetObjectRelationships", "canAddPolicy", "canRemovePolicy", "canGetAppliedPolicies", "canGetACL", "canApplyACL"));
    private final Set<String> actions = new HashSet<String>();

    public static final AllowableActions ALL() {
        AllowableActions as = new AllowableActions();
        as.actions.addAll(DEFAULT);
        return as;
    }

    public void addAction(String action) {
        this.actions.add(action);
    }

    public boolean isActionAllowed(String action) {
        return this.actions.contains(action);
    }

    public boolean isCanAddObjectToFolder() {
        return this.isActionAllowed(CAN_ADD_TO_FOLDER);
    }

    public boolean isCanApplyACL() {
        return this.isActionAllowed(CAN_APPLY_ACL);
    }

    public boolean isCanApplyPolicy() {
        return this.isActionAllowed(CAN_ADD_POLICY);
    }

    public boolean isCanCancelCheckOut() {
        return this.isActionAllowed(CAN_CANCEL_CHECKOUT);
    }

    public boolean isCanCheckIn() {
        return this.isActionAllowed(CAN_CHECKIN);
    }

    public boolean isCanCheckOut() {
        return this.isActionAllowed(CAN_CHECKOUT);
    }

    public boolean isCanCreateDocument() {
        return this.isActionAllowed(CAN_CREATE_DOCUMENT);
    }

    public boolean isCanCreateFolder() {
        return this.isActionAllowed(CAN_CREATE_FOLDER);
    }

    public boolean isCanCreateRelationship() {
        return this.isActionAllowed(CAN_CREATE_RELATIONSHIP);
    }

    public boolean isCanDeleteContentStream() {
        return this.isActionAllowed(CAN_DELETE_CONTENT_STREAM);
    }

    public boolean isCanDeleteObject() {
        return this.isActionAllowed(CAN_DELETE);
    }

    public boolean isCanDeleteTree() {
        return this.isActionAllowed(CAN_DELETE_TREE);
    }

    public boolean isCanGetACL() {
        return this.isActionAllowed(CAN_GET_ACL);
    }

    public boolean isCanGetAllVersions() {
        return this.isActionAllowed(CAN_GET_ALL_VERSIONS);
    }

    public boolean isCanGetAppliedPolicies() {
        return this.isActionAllowed(CAN_GET_APPLIED_POLICIES);
    }

    public boolean isCanGetChildren() {
        return this.isActionAllowed(CAN_GET_CHILDREN);
    }

    public boolean isCanGetContentStream() {
        return this.isActionAllowed(CAN_GET_CONTENT_STREAM);
    }

    public boolean isCanGetDescendants() {
        return this.isActionAllowed(CAN_GET_DESCENDENTS);
    }

    public boolean isCanGetFolderParent() {
        return this.isActionAllowed(CAN_GET_FOLDER_PARENT);
    }

    public boolean isCanGetFolderTree() {
        return this.isActionAllowed(CAN_GET_FOLDER_TREE);
    }

    public boolean isCanGetObjectParents() {
        return this.isActionAllowed(CAN_GET_OBJECT_PARENTS);
    }

    public boolean isCanGetObjectRelationships() {
        return this.isActionAllowed(CAN_GET_OBJECT_RELATIONSHIPS);
    }

    public boolean isCanGetProperties() {
        return this.isActionAllowed(CAN_GET_PROPERTIES);
    }

    public boolean isCanGetRenditions() {
        return this.isActionAllowed(CAN_GET_RENDITIONS);
    }

    public boolean isCanMoveObject() {
        return this.isActionAllowed(CAN_MOVE_OBJECT);
    }

    public boolean isCanRemoveObjectFromFolder() {
        return this.isActionAllowed(CAN_REMOVE_OBJECT_FROM_FOLDER);
    }

    public boolean isCanRemovePolicy() {
        return this.isActionAllowed(CAN_REMOVE_POLICY);
    }

    public boolean isCanSetContentStream() {
        return this.isActionAllowed(CAN_SET_CONTENT_STREAM);
    }

    public boolean isCanUpdateProperties() {
        return this.isActionAllowed(CAN_UPDATE_PROPERTIES);
    }

    public void removeAction(String action) {
        this.actions.remove(action);
    }

    public void setCanAddObjectToFolder(boolean canAddObjectToFolder) {
        if (canAddObjectToFolder) {
            this.addAction(CAN_ADD_TO_FOLDER);
        } else {
            this.removeAction(CAN_ADD_TO_FOLDER);
        }
    }

    public void setCanApplyACL(boolean canApplyACL) {
        if (canApplyACL) {
            this.addAction(CAN_APPLY_ACL);
        } else {
            this.removeAction(CAN_APPLY_ACL);
        }
    }

    public void setCanApplyPolicy(boolean canApplyPolicy) {
        if (canApplyPolicy) {
            this.addAction(CAN_ADD_POLICY);
        } else {
            this.removeAction(CAN_ADD_POLICY);
        }
    }

    public void setCanCancelCheckOut(boolean canCancelCheckOut) {
        if (canCancelCheckOut) {
            this.addAction(CAN_CANCEL_CHECKOUT);
        } else {
            this.removeAction(CAN_CANCEL_CHECKOUT);
        }
    }

    public void setCanCheckIn(boolean canCheckIn) {
        if (canCheckIn) {
            this.addAction(CAN_CHECKIN);
        } else {
            this.removeAction(CAN_CHECKIN);
        }
    }

    public void setCanCheckOut(boolean canCheckOut) {
        if (canCheckOut) {
            this.addAction(CAN_CHECKOUT);
        } else {
            this.removeAction(CAN_CHECKOUT);
        }
    }

    public void setCanCreateDocument(boolean canCreateDocument) {
        if (canCreateDocument) {
            this.addAction(CAN_CREATE_DOCUMENT);
        } else {
            this.removeAction(CAN_CREATE_DOCUMENT);
        }
    }

    public void setCanCreateFolder(boolean canCreateFolder) {
        if (canCreateFolder) {
            this.addAction(CAN_CREATE_FOLDER);
        } else {
            this.removeAction(CAN_CREATE_FOLDER);
        }
    }

    public void setCanCreateRelationship(boolean canCreateRelationship) {
        if (canCreateRelationship) {
            this.addAction(CAN_CREATE_RELATIONSHIP);
        } else {
            this.removeAction(CAN_CREATE_RELATIONSHIP);
        }
    }

    public void setCanDeleteContentStream(boolean canDeleteContentStream) {
        if (canDeleteContentStream) {
            this.addAction(CAN_DELETE_CONTENT_STREAM);
        } else {
            this.removeAction(CAN_DELETE_CONTENT_STREAM);
        }
    }

    public void setCanDeleteObject(boolean canDeleteObject) {
        if (canDeleteObject) {
            this.addAction(CAN_DELETE);
        } else {
            this.removeAction(CAN_DELETE);
        }
    }

    public void setCanDeleteTree(boolean canDeleteTree) {
        if (canDeleteTree) {
            this.addAction(CAN_DELETE_TREE);
        } else {
            this.removeAction(CAN_DELETE_TREE);
        }
    }

    public void setCanGetACL(boolean canGetACL) {
        if (canGetACL) {
            this.addAction(CAN_GET_ACL);
        } else {
            this.removeAction(CAN_GET_ACL);
        }
    }

    public void setCanGetAllVersions(boolean canGetAllVersions) {
        if (canGetAllVersions) {
            this.addAction(CAN_GET_ALL_VERSIONS);
        } else {
            this.removeAction(CAN_GET_ALL_VERSIONS);
        }
    }

    public void setCanGetAppliedPolicies(boolean canGetAppliedPolicies) {
        if (canGetAppliedPolicies) {
            this.addAction(CAN_GET_APPLIED_POLICIES);
        } else {
            this.removeAction(CAN_GET_APPLIED_POLICIES);
        }
    }

    public void setCanGetChildren(boolean canGetChildren) {
        if (canGetChildren) {
            this.addAction(CAN_GET_CHILDREN);
        } else {
            this.removeAction(CAN_GET_CHILDREN);
        }
    }

    public void setCanGetContentStream(boolean canGetContentStream) {
        if (canGetContentStream) {
            this.addAction(CAN_GET_CONTENT_STREAM);
        } else {
            this.removeAction(CAN_GET_CONTENT_STREAM);
        }
    }

    public void setCanGetDescendants(boolean canGetDescendants) {
        if (canGetDescendants) {
            this.addAction(CAN_GET_DESCENDENTS);
        } else {
            this.removeAction(CAN_GET_DESCENDENTS);
        }
    }

    public void setCanGetFolderParent(boolean canGetFolderParent) {
        if (canGetFolderParent) {
            this.addAction(CAN_GET_FOLDER_PARENT);
        } else {
            this.removeAction(CAN_GET_FOLDER_PARENT);
        }
    }

    public void setCanGetFolderTree(boolean canGetFolderTree) {
        if (canGetFolderTree) {
            this.addAction(CAN_GET_FOLDER_TREE);
        } else {
            this.removeAction(CAN_GET_FOLDER_TREE);
        }
    }

    public void setCanGetObjectParents(boolean canGetObjectParents) {
        if (canGetObjectParents) {
            this.addAction(CAN_GET_OBJECT_PARENTS);
        } else {
            this.removeAction(CAN_GET_OBJECT_PARENTS);
        }
    }

    public void setCanGetObjectRelationships(boolean canGetObjectRelationships) {
        if (canGetObjectRelationships) {
            this.addAction(CAN_GET_OBJECT_RELATIONSHIPS);
        } else {
            this.removeAction(CAN_GET_OBJECT_RELATIONSHIPS);
        }
    }

    public void setCanGetProperties(boolean canGetProperties) {
        if (canGetProperties) {
            this.addAction(CAN_GET_PROPERTIES);
        } else {
            this.removeAction(CAN_GET_PROPERTIES);
        }
    }

    public void setCanGetRenditions(boolean canGetRenditions) {
        if (canGetRenditions) {
            this.addAction(CAN_GET_RENDITIONS);
        } else {
            this.removeAction(CAN_GET_RENDITIONS);
        }
    }

    public void setCanMoveObject(boolean canMoveObject) {
        if (canMoveObject) {
            this.addAction(CAN_MOVE_OBJECT);
        } else {
            this.removeAction(CAN_MOVE_OBJECT);
        }
    }

    public void setCanRemoveObjectFromFolder(boolean canRemoveObjectFromFolder) {
        if (canRemoveObjectFromFolder) {
            this.addAction(CAN_REMOVE_OBJECT_FROM_FOLDER);
        } else {
            this.removeAction(CAN_REMOVE_OBJECT_FROM_FOLDER);
        }
    }

    public void setCanRemovePolicy(boolean canRemovePolicy) {
        if (canRemovePolicy) {
            this.addAction(CAN_REMOVE_POLICY);
        } else {
            this.removeAction(CAN_REMOVE_POLICY);
        }
    }

    public void setCanSetContentStream(boolean canSetContentStream) {
        if (canSetContentStream) {
            this.addAction(CAN_SET_CONTENT_STREAM);
        } else {
            this.removeAction(CAN_SET_CONTENT_STREAM);
        }
    }

    public void setCanUpdateProperties(boolean canUpdateProperties) {
        if (canUpdateProperties) {
            this.addAction(CAN_UPDATE_PROPERTIES);
        } else {
            this.removeAction(CAN_UPDATE_PROPERTIES);
        }
    }
}

