/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionDatas;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.nodetype.AbstractNodeTypeRepository;
import org.exoplatform.services.jcr.impl.core.nodetype.ItemDefinitionDataHolder;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeDataHierarchyHolder;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeRepository;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.NodeTypeDataPersister;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InmemoryNodeTypeRepository
extends AbstractNodeTypeRepository {
    private final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.InmemoryNodeTypeRepository");
    private final ItemDefinitionDataHolder defsHolder;
    private final NodeTypeDataHierarchyHolder hierarchy;
    private boolean haveTypes = false;

    public InmemoryNodeTypeRepository(ItemDefinitionDataHolder defsHolder, NodeTypeDataHierarchyHolder hierarchy, NodeTypeDataPersister nodeTypeDataPersister) {
        super(nodeTypeDataPersister);
        this.defsHolder = defsHolder;
        this.hierarchy = hierarchy;
    }

    public InmemoryNodeTypeRepository(NodeTypeDataPersister nodeTypeDataPersister) {
        super(nodeTypeDataPersister);
        this.hierarchy = new NodeTypeDataHierarchyHolder();
        this.defsHolder = new ItemDefinitionDataHolder();
    }

    @Override
    public void addNodeType(NodeTypeData nodeType, Map<InternalQName, NodeTypeData> volatileNodeTypes) throws RepositoryException {
        this.hierarchy.addNodeType(nodeType, volatileNodeTypes);
        Set<InternalQName> supers = this.hierarchy.getSupertypes(nodeType.getName(), volatileNodeTypes);
        for (InternalQName superName : supers) {
            this.defsHolder.putDefinitions(nodeType.getName(), this.hierarchy.getNodeType(superName, volatileNodeTypes));
        }
        this.haveTypes = true;
        this.defsHolder.putDefinitions(nodeType.getName(), nodeType);
    }

    @Override
    public List<NodeTypeData> getAllNodeTypes() {
        if (!this.haveTypes) {
            try {
                return super.getAllNodeTypes();
            }
            catch (RepositoryException e) {
                this.log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return this.hierarchy.getAllNodeTypes();
    }

    public NodeDefinitionData getChildNodeDefinition(InternalQName parentTypeName, InternalQName nodeName, InternalQName nodeTypeName) {
        return this.defsHolder.getChildNodeDefinition(parentTypeName, nodeName, nodeTypeName);
    }

    @Override
    public Set<InternalQName> getDeclaredSubtypes(InternalQName nodeTypeName) {
        return this.hierarchy.getDeclaredSubtypes(nodeTypeName);
    }

    @Override
    public NodeDefinitionData getDefaultChildNodeDefinition(InternalQName nodeName, InternalQName[] nodeTypeNames) {
        return this.defsHolder.getDefaultChildNodeDefinition(nodeName, nodeTypeNames);
    }

    @Override
    public NodeTypeData getNodeType(InternalQName typeName) {
        return this.hierarchy.getNodeType(typeName);
    }

    public NodeTypeData getNodeType(InternalQName superName, Map<InternalQName, NodeTypeData> volatileNodeTypes) {
        return this.hierarchy.getNodeType(superName, volatileNodeTypes);
    }

    @Override
    public PropertyDefinitionDatas getPropertyDefinitions(InternalQName propertyName, InternalQName[] nodeTypeNames) {
        return this.defsHolder.getPropertyDefinitions(propertyName, nodeTypeNames);
    }

    @Override
    public Set<InternalQName> getSubtypes(InternalQName nodeTypeName) {
        return this.hierarchy.getSubtypes(nodeTypeName);
    }

    @Override
    public Set<InternalQName> getSupertypes(InternalQName ntname) {
        return this.hierarchy.getSupertypes(ntname);
    }

    public Set<InternalQName> getSupertypes(InternalQName name, Map<InternalQName, NodeTypeData> volatileNodeTypes) throws RepositoryException {
        return this.hierarchy.getSupertypes(name, volatileNodeTypes);
    }

    @Override
    public boolean isNodeType(InternalQName testTypeName, InternalQName[] typesNames) {
        return this.hierarchy.isNodeType(testTypeName, typesNames);
    }

    @Override
    public boolean isNodeType(InternalQName testTypeName, InternalQName primaryType) {
        return this.hierarchy.isNodeType(testTypeName, primaryType);
    }

    @Override
    public NodeTypeRepository createCopy() {
        return new InmemoryNodeTypeRepository(this.defsHolder.createCopy(), this.hierarchy.createCopy(), this.nodeTypeDataPersister);
    }

    @Override
    public void removeNodeType(NodeTypeData nodeType) {
        InternalQName nodeTypeName = nodeType.getName();
        Set<InternalQName> supers = this.hierarchy.getSubtypes(nodeTypeName);
        this.hierarchy.removeNodeType(nodeTypeName);
        if (supers != null) {
            for (InternalQName superName : supers) {
                this.defsHolder.removeDefinitions(nodeTypeName, this.hierarchy.getNodeType(superName));
            }
        }
        this.defsHolder.removeDefinitions(nodeTypeName, nodeType);
        this.haveTypes = this.hierarchy.getAllNodeTypes().size() > 0;
    }
}

