/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml.importing;

import java.util.Map;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.access.AccessManager;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.xml.importing.SystemViewImporter;
import org.exoplatform.services.jcr.impl.xml.importing.dataflow.ImportNodeData;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceContentImporter
extends SystemViewImporter {
    protected final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.WorkspaceContentImporter");
    protected boolean isFirstElementChecked = false;

    public WorkspaceContentImporter(NodeData parent, QPath ancestorToSave, int uuidBehavior, ItemDataConsumer dataConsumer, NodeTypeDataManager ntManager, LocationFactory locationFactory, ValueFactoryImpl valueFactory, NamespaceRegistry namespaceRegistry, AccessManager accessManager, ConversationState userState, Map<String, Object> context, RepositoryImpl repository, String currentWorkspaceName) {
        super(parent, ancestorToSave, uuidBehavior, dataConsumer, ntManager, locationFactory, valueFactory, namespaceRegistry, accessManager, userState, context, repository, currentWorkspaceName);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String name, Map<String, String> atts) throws RepositoryException {
        InternalQName elementName = this.locationFactory.parseJCRName(name).getInternalName();
        if (Constants.SV_NODE_NAME.equals((Object)elementName)) {
            ImportNodeData newNodeData;
            String svName = this.getAttribute(atts, Constants.SV_NAME_NAME);
            if (svName == null) {
                throw new RepositoryException("Missing mandatory sv:name attribute of element sv:node");
            }
            String svId = this.getAttribute(atts, Constants.EXO_ID_NAME);
            if (svId == null) {
                throw new RepositoryException("Missing mandatory exo:id attribute of element sv:node");
            }
            int nodeIndex = 1;
            NodeData parentData = this.getParent();
            if (!this.isFirstElementChecked) {
                if (!this.ROOT_NODE_NAME.equals(svName)) {
                    throw new RepositoryException("The first element must be root. But found '" + svName + "'");
                }
                this.isFirstElementChecked = true;
            }
            if (this.ROOT_NODE_NAME.equals(svName)) {
                InternalQName currentNodeName = Constants.ROOT_PATH.getName();
                newNodeData = this.processRootNode(parentData.getQPath());
            } else {
                InternalQName currentNodeName = this.locationFactory.parseJCRName(svName).getInternalName();
                nodeIndex = this.getNodeIndex(parentData, currentNodeName, null);
                newNodeData = new ImportNodeData(parentData, currentNodeName, nodeIndex);
                newNodeData.setOrderNumber(this.getNextChildOrderNum(parentData));
                newNodeData.setIdentifier(svId);
                this.changesLog.add(new ItemState(newNodeData, 1, true, parentData.getQPath()));
            }
            this.tree.push(newNodeData);
        } else {
            super.startElement(namespaceURI, localName, name, atts);
            if (Constants.SV_PROPERTY_NAME.equals((Object)elementName)) {
                String svId = this.getAttribute(atts, Constants.EXO_ID_NAME);
                if (svId == null) {
                    throw new RepositoryException("Missing mandatory exo:id attribute of element sv:property");
                }
                this.propertyInfo.setIndentifer(svId);
            }
        }
    }

    protected ImportNodeData processRootNode(QPath parentPath) {
        this.tree.pop();
        ImportNodeData newNodeData = new ImportNodeData(Constants.ROOT_PATH, "00exo0jcr0root0uuid0000000000000", -1, Constants.NT_UNSTRUCTURED, new InternalQName[0], 0, null, new AccessControlList());
        this.changesLog.add(new ItemState(newNodeData, 1, true, parentPath, false, false));
        return newNodeData;
    }
}

