/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.text;

import org.gatein.common.util.ParameterValidation;

public class TextTools {
    public static boolean isAlphaNumeric(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static char toHex(int z) throws IllegalArgumentException {
        if (z >= 0 && z < 10) {
            return (char)(48 + z);
        }
        if (z >= 10 && z < 16) {
            return (char)(55 + z);
        }
        throw new IllegalArgumentException("Wrong character");
    }

    public static String replace(String string, String pattern, String replacement) {
        StringBuffer buffer = new StringBuffer(string.length());
        int previous = 0;
        int current = string.indexOf(pattern);
        while (current != -1) {
            buffer.append(string.substring(previous, current));
            buffer.append(replacement);
            previous = current + pattern.length();
            current = string.indexOf(pattern, previous);
        }
        buffer.append(string.substring(previous));
        return buffer.toString();
    }

    public static String replaceAllInstancesOfBoundedString(String initial, String prefix, String suffix, String replacement) {
        return TextTools.replaceBoundedString(initial, prefix, suffix, replacement, true, false, false);
    }

    public static String replaceAllInstancesOfBoundedString(String initial, String prefix, String suffix, StringReplacementGenerator generator) {
        return TextTools.replaceBoundedString(initial, prefix, suffix, generator, true, false, false);
    }

    public static String replaceBoundedString(String initial, String prefix, String suffix, String replacement, boolean replaceIfBoundedStringEmpty, boolean keepBoundaries) {
        ParameterValidation.throwIllegalArgExceptionIfNull(replacement, "replacement");
        return TextTools.replaceBoundedString(initial, prefix, suffix, new ConstantStringReplacementGenerator(replacement), replaceIfBoundedStringEmpty, keepBoundaries, false);
    }

    public static String replaceBoundedString(String initial, String prefix, String suffix, String replacement, boolean replaceIfBoundedStringEmpty, boolean keepBoundaries, boolean suffixIsOptional) {
        ParameterValidation.throwIllegalArgExceptionIfNull(replacement, "replacement");
        return TextTools.replaceBoundedString(initial, prefix, suffix, new ConstantStringReplacementGenerator(replacement), replaceIfBoundedStringEmpty, keepBoundaries, suffixIsOptional);
    }

    public static String replaceBoundedString(String initial, String prefix, String suffix, StringReplacementGenerator generator, boolean replaceIfBoundedStringEmpty, boolean keepBoundaries) {
        return TextTools.replaceBoundedString(initial, prefix, suffix, generator, replaceIfBoundedStringEmpty, keepBoundaries, false);
    }

    public static String replaceBoundedString(String initial, String prefix, String suffix, StringReplacementGenerator generator, boolean replaceIfBoundedStringEmpty, boolean keepBoundaries, boolean suffixIsOptional) {
        boolean suffixAbsent;
        if (ParameterValidation.isNullOrEmpty(initial)) {
            return initial;
        }
        ParameterValidation.throwIllegalArgExceptionIfNull(generator, "StringReplacementGenerator");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty(prefix, "prefix", "TextTools.replaceBoundedString");
        StringBuilder tmp = new StringBuilder(initial);
        int prefixIndex = tmp.indexOf(prefix);
        int prefixLength = prefix.length();
        boolean bl = suffixAbsent = suffix == null;
        if (!suffixIsOptional && suffix != null && tmp.indexOf(suffix) == -1) {
            return initial;
        }
        while (prefixIndex != -1) {
            int nextPrefixIndex;
            if (suffixAbsent) {
                if (keepBoundaries) {
                    tmp.insert(prefixIndex + prefixLength, generator.getReplacementFor(prefix, prefix, suffix));
                } else {
                    tmp.delete(prefixIndex, prefixIndex + prefixLength);
                    tmp.insert(prefixIndex, generator.getReplacementFor(prefix, prefix, suffix));
                }
                prefixIndex = tmp.indexOf(prefix, prefixIndex + prefixLength);
                continue;
            }
            int suffixIndex = tmp.indexOf(suffix, prefixIndex);
            if (suffixIndex == -1) {
                suffixAbsent = true;
                continue;
            }
            if (suffixIsOptional && (nextPrefixIndex = tmp.indexOf(prefix, prefixIndex + prefixLength)) != -1 && nextPrefixIndex <= suffixIndex) {
                tmp.delete(prefixIndex, prefixIndex + prefixLength);
                String replacement = generator.getReplacementFor(prefix, prefix, suffix);
                tmp.insert(prefixIndex, replacement);
                prefixIndex = nextPrefixIndex - prefixLength + replacement.length();
                continue;
            }
            if (replaceIfBoundedStringEmpty || suffixIndex != prefixIndex + prefixLength) {
                String match = tmp.substring(prefixIndex + prefixLength, suffixIndex);
                if (keepBoundaries) {
                    if (suffix != null) {
                        tmp.delete(prefixIndex + prefixLength, suffixIndex);
                    }
                    tmp.insert(prefixIndex + prefixLength, generator.getReplacementFor(match, prefix, suffix));
                } else {
                    int suffixLength;
                    int n = suffixLength = suffix != null ? suffix.length() : 0;
                    if (suffix != null) {
                        tmp.delete(prefixIndex, suffixIndex + suffixLength);
                    } else {
                        tmp.delete(prefixIndex, prefixIndex + prefixLength);
                    }
                    tmp.insert(prefixIndex, generator.getReplacementFor(match, prefix, suffix));
                }
            }
            prefixIndex = tmp.indexOf(prefix, prefixIndex + prefixLength);
        }
        return tmp.toString();
    }

    public static class ConstantStringReplacementGenerator
    implements StringReplacementGenerator {
        private String replacement;

        public ConstantStringReplacementGenerator(String replacement) {
            this.replacement = replacement;
        }

        public String getReplacementFor(String match, String prefix, String suffix) {
            return this.replacement;
        }
    }

    public static interface StringReplacementGenerator {
        public String getReplacementFor(String var1, String var2, String var3);
    }
}

