/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import com.google.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.shindig.auth.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthInfo {
    private HttpServletRequest req;

    @Inject
    public AuthInfo(HttpServletRequest req) {
        this.req = req;
    }

    public SecurityToken getSecurityToken() {
        return (SecurityToken)AuthInfo.getRequestAttribute(this.req, Attribute.SECURITY_TOKEN);
    }

    public String getAuthType() {
        return (String)AuthInfo.getRequestAttribute(this.req, Attribute.AUTH_TYPE);
    }

    AuthInfo setSecurityToken(SecurityToken token) {
        AuthInfo.setRequestAttribute(this.req, Attribute.SECURITY_TOKEN, token);
        return this;
    }

    AuthInfo setAuthType(String authType) {
        AuthInfo.setRequestAttribute(this.req, Attribute.AUTH_TYPE, authType);
        return this;
    }

    private static <T> void setRequestAttribute(HttpServletRequest req, Attribute att, T value) {
        req.setAttribute(att.getId(), value);
    }

    private static <T> T getRequestAttribute(HttpServletRequest req, Attribute att) {
        return (T)req.getAttribute(att.getId());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Attribute {
        SECURITY_TOKEN,
        AUTH_TYPE;


        public String getId() {
            return Attribute.class.getName() + '.' + this.name();
        }
    }
}

