/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import javax.resource.spi.XATerminator;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.Log;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionImpl;
import org.objectweb.jotm.XidImpl;

public class XATerminatorImpl
implements XATerminator {
    private static transient XATerminatorImpl unique = null;
    private TransactionImpl iftx = null;
    private Xid xid;
    private Log mylog;
    private int errorCode;
    private static final int XA_RBBASE = 100;
    private static final int XA_RBROLLBACK = 100;
    private static final int XA_RBCOMMFAIL = 101;
    private static final int XA_RBDEADLOCK = 102;
    private static final int XA_RBINTEGRITY = 103;
    private static final int XA_RBOTHER = 104;
    private static final int XA_RBPROTO = 105;
    private static final int XA_RBRBTIMEOUT = 106;
    private static final int XA_RBTRANSIENT = 107;
    private static final int XA_RBEND = 107;
    private static final int XA_NOMIGRATE = 9;
    private static final int XA_HEURHAZ = 8;
    private static final int XA_HEURCOM = 7;
    private static final int XA_HEURRB = 6;
    private static final int XA_HEURMIX = 5;
    private static final int XA_NOTUSED1 = 4;
    private static final int XA_RDONLY = 3;
    private static final int XAER_RMERR = -3;
    private static final int XAER_NOTA = -4;
    private static final int XAER_INVAL = -5;
    private static final int XAER_PROTO = -6;
    private static final int XAER_RMFAIL = -7;
    private static final int XAER_DUPID = -8;
    private static final int XAER_OUTSIDE = -9;

    public XATerminatorImpl() throws XAException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)"create XATerminator");
        }
        unique = this;
    }

    public String get_transaction_name() throws XAException {
        TraceTm.jotm.debug((Object)"XATerminatorImpl.get_transaction_name()");
        return this.xid.toString();
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("commit xid=" + xid + "onePhase=" + onePhase));
        }
        XidImpl myxid = new XidImpl(xid);
        this.iftx = Current.getCurrent().getTxByXid(myxid);
        if (this.iftx == null) {
            TraceTm.jotm.error((Object)("XATerminatorImpl.commit(): unknown xid " + xid));
            throw new XAException(-4);
        }
        try {
            this.iftx.commit();
        }
        catch (Exception e) {
            TraceTm.jotm.error((Object)"XATerminatorImpl.commit(): commit raised exception ", (Throwable)e);
        }
    }

    public void rollback(Xid xid) throws XAException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("rollback xid=" + xid));
        }
        XidImpl myxid = new XidImpl(xid);
        this.iftx = Current.getCurrent().getTxByXid(myxid);
        if (this.iftx == null) {
            TraceTm.jotm.error((Object)("XATerminatorImpl.rollback(): unknown xid " + xid));
            throw new XAException(-4);
        }
        try {
            this.iftx.rollback();
        }
        catch (Exception e) {
            TraceTm.jotm.error((Object)"XATerminatorImpl.rollback(): rollback raised exception ", (Throwable)e);
        }
    }

    public int prepare(Xid xid) throws XAException {
        int ret = 0;
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("prepare xid=" + xid));
        }
        XidImpl myxid = new XidImpl(xid);
        this.iftx = Current.getCurrent().getTxByXid(myxid);
        if (this.iftx == null) {
            TraceTm.jotm.error((Object)("XATerminatorImpl.prepare(): unknown xid " + xid));
            throw new XAException(-4);
        }
        try {
            ret = this.iftx.prepare();
        }
        catch (Exception e) {
            TraceTm.jotm.error((Object)"XATerminatorImpl.prepare(): prepare raised exception ", (Throwable)e);
        }
        return ret;
    }

    public void forget(Xid xid) throws XAException {
        TraceTm.jotm.debug((Object)"XATerminatorImpl.forget()");
        XidImpl myxid = new XidImpl(xid);
        try {
            Current.getCurrent().forgetTx(myxid);
        }
        catch (Exception e) {
            TraceTm.jotm.error((Object)"XATerminatorImpl.forget(): forget raised exception ", (Throwable)e);
        }
    }

    public Xid[] recover(int flag) throws XAException {
        TraceTm.jotm.debug((Object)"XATerminatorImpl.recover()");
        return Current.getCurrent().getPreparedHeuristicXid();
    }
}

