/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service;

public class SortSettings {
    private SortField field = SortField.ORDER;
    private Direction direction = Direction.ASC;

    public SortSettings(String field, String direction) {
        this.field = this.toField(field);
        this.direction = this.toDirection(direction);
    }

    public SortSettings(SortField field, Direction direction) {
        this.field = field;
        this.direction = direction;
    }

    public SortField getField() {
        return this.field;
    }

    public Direction getDirection() {
        return this.direction;
    }

    private SortField toField(String sortBy) {
        if ("name".equalsIgnoreCase(sortBy)) {
            return SortField.NAME;
        }
        if ("createdDate".equalsIgnoreCase(sortBy)) {
            return SortField.CREATED;
        }
        if ("isLock".equalsIgnoreCase(sortBy)) {
            return SortField.ISLOCK;
        }
        if ("topicCount".equalsIgnoreCase(sortBy)) {
            return SortField.TOPICCOUNT;
        }
        if ("lastPostDate".equalsIgnoreCase(sortBy)) {
            return SortField.LASTPOST;
        }
        if ("postCount".equalsIgnoreCase(sortBy)) {
            return SortField.POSTCOUNT;
        }
        if ("viewCount".equalsIgnoreCase(sortBy)) {
            return SortField.VIEWCOUNT;
        }
        if ("numberAttachments".equalsIgnoreCase(sortBy)) {
            return SortField.ATTACHMENTS;
        }
        return SortField.ORDER;
    }

    private Direction toDirection(String direction) {
        return "descending".equalsIgnoreCase(direction) ? Direction.DESC : Direction.ASC;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SortField {
        NAME("name"),
        ORDER("forumOrder"),
        CREATED("createdDate"),
        LASTPOST("lastPostDate"),
        POSTCOUNT("postCount"),
        TOPICCOUNT("topicCount"),
        ISLOCK("isLock"),
        VIEWCOUNT("viewCount"),
        ATTACHMENTS("numberAttachments");

        private final String name;

        private SortField(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        ASC("ascending"),
        DESC("descending");

        private final String name;

        private Direction(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

