/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.impl;

import org.exoplatform.forum.service.DataStorage;
import org.exoplatform.forum.service.ForumStatistic;
import org.exoplatform.forum.service.ForumStatisticsService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ForumStatisticsServiceImpl
implements ForumStatisticsService {
    private static Log log = ExoLogger.getLogger(ForumStatisticsServiceImpl.class);
    private DataStorage dataStorage;

    public ForumStatisticsServiceImpl(DataStorage dataStorage) {
        this.dataStorage = dataStorage;
    }

    public void addMember(String userName) throws Exception {
        ForumStatistic stats = this.dataStorage.getForumStatistic();
        stats.setNewMembers(userName);
        stats.setMembersCount(stats.getMembersCount() + 1L);
        this.dataStorage.saveForumStatistic(stats);
        if (log.isDebugEnabled()) {
            log.debug((Object)(userName + " joined forums. We have" + stats.getMembersCount() + " members now."));
        }
    }

    public void removeMember(String userName) throws Exception {
        ForumStatistic stats;
        long membersCount = (stats = this.dataStorage.getForumStatistic()).getMembersCount();
        stats.setMembersCount(membersCount <= 0L ? 0L : membersCount - 1L);
        if (userName.equals(stats.getNewMembers())) {
            stats.setNewMembers(this.dataStorage.getLatestUser());
        }
        this.dataStorage.saveForumStatistic(stats);
        if (log.isDebugEnabled()) {
            log.debug((Object)(userName + " left forums. We have" + membersCount + " members now."));
        }
    }
}

