/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.transform.impl;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.xml.resolving.XMLResolvingService;
import org.exoplatform.services.xml.transform.AbstractTransformer;
import org.exoplatform.services.xml.transform.NotSupportedIOTypeException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class TransformerBase
implements AbstractTransformer {
    private Result result = null;
    protected Log log = ExoLogger.getLogger((String)"exo.core.component.xml-processing.TransformerBase");
    protected SAXTransformerFactory tSAXFactory;
    protected XMLResolvingService resolvingService;

    public TransformerBase() {
        this.log.debug((Object)("Current javax.xml.parsers.SAXParserFactory sys property [ " + System.getProperty("javax.xml.parsers.SAXParserFactory", "-Not set-") + "]"));
        this.tSAXFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
    }

    public static XMLReader getXMLReader() throws SAXException {
        return XMLReaderFactory.createXMLReader();
    }

    public void setResolvingService(XMLResolvingService r) {
        this.resolvingService = r;
    }

    protected void afterInitResult() {
        this.log.debug((Object)"Result is set");
    }

    public final void initResult(Result result) throws NotSupportedIOTypeException {
        if (!this.isResultSupported(result)) {
            throw new NotSupportedIOTypeException(result);
        }
        this.result = result;
        this.afterInitResult();
    }

    protected Result getResult() {
        return this.result;
    }

    protected boolean isSourceSupported(Source source) {
        return true;
    }

    protected boolean isResultSupported(Result result) {
        return true;
    }

    protected abstract void internalTransform(Source var1) throws NotSupportedIOTypeException, TransformerException, IllegalStateException;

    public final void transform(Source source) throws NotSupportedIOTypeException, TransformerException, IllegalStateException {
        if (!this.isSourceSupported(source)) {
            this.log.error((Object)("source of type " + source.getClass().getName() + " not supported"));
            throw new NotSupportedIOTypeException(source);
        }
        if (this.result == null) {
            this.log.error((Object)"Result not set");
            throw new IllegalStateException("Result not specified. See initResult(Result)");
        }
        this.internalTransform(source);
    }

    public void transformInputStream2Result(InputStream input, Result result) throws TransformerException {
        this.log.debug((Object)("Transform InputStream to result of type " + result.getClass().getName()));
        if (result instanceof StreamResult) {
            OutputStream outputStream = ((StreamResult)result).getOutputStream();
            try {
                int counter = 0;
                while (input.available() > 0) {
                    byte[] byteArray = new byte[input.available()];
                    int readBytes = input.read(byteArray);
                    counter += readBytes;
                    outputStream.write(byteArray, 0, readBytes);
                }
                this.log.debug((Object)("Write " + counter + " bytes to ouput stream"));
            }
            catch (IOException ex) {
                this.log.error((Object)"Error on read/write ", (Throwable)ex);
                throw new TransformerException(ex);
            }
        }
        XMLReader xmlReader = null;
        try {
            xmlReader = TransformerBase.getXMLReader();
            this.log.debug((Object)("xmlReader class is " + xmlReader.getClass().getName()));
            if (this.resolvingService != null) {
                xmlReader.setEntityResolver(this.resolvingService.getEntityResolver());
                this.log.debug((Object)"Set entity resolver");
            }
            if (result instanceof SAXResult) {
                SAXResult saxResult = (SAXResult)result;
                xmlReader.setContentHandler(saxResult.getHandler());
                this.log.debug((Object)"Parse direct to result");
            } else {
                this.log.debug((Object)"Create empty transformation");
                TransformerHandler transformerHandler = this.tSAXFactory.newTransformerHandler();
                transformerHandler.setResult(result);
                xmlReader.setContentHandler(transformerHandler);
                this.log.debug((Object)"Parse to result throw empty transformer");
            }
            xmlReader.parse(new InputSource(input));
            this.log.debug((Object)"Parse complete");
        }
        catch (SAXException ex) {
            throw new TransformerException(ex);
        }
        catch (IOException ex) {
            throw new TransformerException(ex);
        }
    }

    protected InputStream sourceAsInputStream(Source source) throws NotSupportedIOTypeException {
        InputSource inputSource = SAXSource.sourceToInputSource(source);
        if (inputSource == null) {
            throw new NotSupportedIOTypeException(source);
        }
        return inputSource.getByteStream();
    }

    protected void writeTofile(byte[] bytes, String postfix) {
        String POSTFIX = new SimpleDateFormat("yy-MM-DD_HH-mm-ss_").format(new Date());
        try {
            FileOutputStream fileLog = new FileOutputStream("c:/tmp/transf" + POSTFIX + postfix + ".xhtml");
            fileLog.write(bytes);
            fileLog.flush();
            fileLog.close();
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException ex) {
            // empty catch block
        }
    }
}

