/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.collaboration;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Path(value="/bundle/")
public class ResourceBundleConnector
implements ResourceContainer {
    @GET
    @Path(value="/getBundle/")
    public Response getBundle(@QueryParam(value="key") String multiKey, @QueryParam(value="locale") String locale) {
        try {
            ResourceBundleService resourceBundleService = (ResourceBundleService)WCMCoreUtils.getService(ResourceBundleService.class);
            String[] resourceBundleNames = resourceBundleService.getSharedResourceBundleNames();
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element bundles = document.createElement("bundles");
            bundles.setAttribute("locale", locale);
            String[] keys = multiKey.split(",");
            for (String resourceBundleName : resourceBundleNames) {
                for (String key : keys) {
                    try {
                        ResourceBundle resourceBundle = resourceBundleService.getResourceBundle(resourceBundleName, new Locale(locale));
                        String value = resourceBundle.getString(key);
                        Element element = document.createElement(key);
                        element.setAttribute("value", value);
                        bundles.appendChild(element);
                    }
                    catch (MissingResourceException e) {
                        // empty catch block
                    }
                }
            }
            document.appendChild(bundles);
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoCache(true);
            cacheControl.setNoStore(true);
            return Response.ok((Object)new DOMSource(document), (String)"text/xml").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }
}

