/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.utils;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.exoplatform.services.jcr.impl.core.query.lucene.TwoWayRangeIterator;
import org.exoplatform.services.wcm.utils.PaginatedNodeIterator;

public class PaginatedQueryResult
extends PaginatedNodeIterator {
    private RowIterator rowIterator;

    public PaginatedQueryResult(int pageSize) {
        super(pageSize);
    }

    public PaginatedQueryResult(QueryResult queryResult, int pageSize) throws Exception {
        super(pageSize);
        NodeIterator nodeIterator = queryResult.getNodes();
        while (nodeIterator.hasNext()) {
            this.nodes.add(nodeIterator.nextNode());
        }
        this.setAvailablePage(this.nodes.size());
        this.rowIterator = queryResult.getRows();
    }

    protected void populateCurrentPage(int page) throws Exception {
        this.checkAndSetPosition(page);
        TwoWayRangeIterator twoWayRangeIterator = (TwoWayRangeIterator)this.nodes;
        this.currentListPage_ = new ArrayList();
        int count = 0;
        for (int i = 0; i < this.nodes.size(); ++i) {
            Node node = (Node)this.nodes.get(i);
            Node viewNode = this.filterNodeToDisplay(node);
            if (viewNode == null) continue;
            twoWayRangeIterator.skipBack(1L);
            Row row = this.rowIterator.nextRow();
            ResultNode resultNode = new ResultNode(viewNode, row);
            this.currentListPage_.add(resultNode);
            if (++count == this.getPageSize()) break;
        }
        this.currentPage_ = page;
    }

    protected Node filterNodeToDisplay(Node node) throws Exception {
        Node displayNode = node;
        if (node.isNodeType("nt:resource")) {
            displayNode = node.getParent();
        }
        return displayNode;
    }

    public static class ResultNode {
        private Node node;
        private float score;
        private String excerpt;
        private String spellSuggestion;

        public ResultNode(Node node, Row row) throws RepositoryException {
            this.node = node;
            Value excerpt = row.getValue("rep:excerpt(.)");
            this.excerpt = excerpt == null ? "" : excerpt.getString();
            this.spellSuggestion = row.getValue("rep:spellcheck()").getString();
            this.score = row.getValue("jcr:score").getLong();
        }

        public Node getNode() {
            return this.node;
        }

        public void setNode(Node node) {
            this.node = node;
        }

        public float getScore() {
            return this.score;
        }

        public void setScore(float score) {
            this.score = score;
        }

        public String getExcerpt() {
            return this.excerpt;
        }

        public void setExcerpt(String excerpt) {
            this.excerpt = excerpt;
        }

        public String getSpellSuggestion() {
            return this.spellSuggestion;
        }

        public void setSpellSuggestion(String spellSuggestion) {
            this.spellSuggestion = spellSuggestion;
        }
    }
}

