/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.model.operand;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.xcmis.search.QueryObjectModelVisitor;
import org.xcmis.search.VisitException;
import org.xcmis.search.Visitors;
import org.xcmis.search.model.operand.DynamicOperand;
import org.xcmis.search.model.source.SelectorName;

public class PropertyValue
extends DynamicOperand {
    private static final long serialVersionUID = 1L;
    private final String propertyName;
    private final int hcode;

    public PropertyValue(SelectorName selectorName, String propertyName) {
        super(selectorName);
        Validate.notNull((Object)propertyName, (String)"The propertyName argument may not be null");
        this.propertyName = propertyName;
        this.hcode = new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)propertyName).toHashCode();
    }

    public void accept(QueryObjectModelVisitor visitor) throws VisitException {
        visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        PropertyValue rhs = (PropertyValue)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.propertyName, (Object)rhs.propertyName).isEquals();
    }

    public final String getPropertyName() {
        return this.propertyName;
    }

    public SelectorName getSelectorName() {
        return this.getSelectorNames().iterator().next();
    }

    public int hashCode() {
        return this.hcode;
    }

    public String toString() {
        return Visitors.readable(this);
    }
}

