/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.newsletter;

import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.newsletter.NewsletterCategoryConfig;
import org.exoplatform.services.wcm.newsletter.NewsletterConstant;
import org.exoplatform.services.wcm.newsletter.NewsletterManagerService;
import org.exoplatform.services.wcm.newsletter.NewsletterSubscriptionConfig;
import org.exoplatform.services.wcm.newsletter.config.NewsletterUserConfig;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterCategoryHandler;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterManageUserHandler;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterSubscriptionHandler;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.picocontainer.Startable;

public class NewsletterInitializationService
implements Startable {
    private List<String> portalNames;
    private List<NewsletterCategoryConfig> categoryConfigs;
    private List<NewsletterSubscriptionConfig> subscriptionConfigs;
    private List<NewsletterUserConfig> userConfigs;
    private NewsletterManagerService newsletterManagerService;
    private LivePortalManagerService livePortalManagerService = (LivePortalManagerService)WCMCoreUtils.getService(LivePortalManagerService.class);
    private static Log log = ExoLogger.getLogger(NewsletterInitializationService.class);

    public NewsletterInitializationService(InitParams initParams, UserPortalConfigService userPortalConfigService) {
        this.newsletterManagerService = (NewsletterManagerService)WCMCoreUtils.getService(NewsletterManagerService.class);
        this.portalNames = initParams.getValuesParam("portalNames").getValues();
        this.categoryConfigs = initParams.getObjectParamValues(NewsletterCategoryConfig.class);
        this.subscriptionConfigs = initParams.getObjectParamValues(NewsletterSubscriptionConfig.class);
        this.userConfigs = initParams.getObjectParamValues(NewsletterUserConfig.class);
    }

    public void start() {
        log.info((Object)"Starting NewsletterInitializationService ... ");
        try {
            SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
            Node dummyNode = this.livePortalManagerService.getLivePortal(sessionProvider, this.portalNames.get(0));
            Session session = dummyNode.getSession();
            Node serviceFolder = session.getRootNode().getNode("exo:services");
            Node newsletterInitializationService = null;
            newsletterInitializationService = serviceFolder.hasNode("NewsletterInitializationService") ? serviceFolder.getNode("NewsletterInitializationService") : serviceFolder.addNode("NewsletterInitializationService", "nt:unstructured");
            if (!newsletterInitializationService.hasNode("NewsletterInitializationServiceLog")) {
                String[] arrayPers = new String[]{"read", "set_property", "add_node", "remove"};
                for (String portalName : this.portalNames) {
                    NewsletterCategoryHandler categoryHandler = this.newsletterManagerService.getCategoryHandler();
                    for (NewsletterCategoryConfig categoryConfig : this.categoryConfigs) {
                        categoryHandler.add(sessionProvider, portalName, categoryConfig);
                    }
                    NewsletterSubscriptionHandler subscriptionHandler = this.newsletterManagerService.getSubscriptionHandler();
                    for (NewsletterSubscriptionConfig subscriptionConfig : this.subscriptionConfigs) {
                        subscriptionHandler.add(sessionProvider, portalName, subscriptionConfig);
                    }
                    NewsletterManageUserHandler manageUserHandler = this.newsletterManagerService.getManageUserHandler();
                    for (NewsletterUserConfig userConfig : this.userConfigs) {
                        manageUserHandler.add(sessionProvider, portalName, userConfig.getMail());
                    }
                    ExtendedNode userFolderNode = (ExtendedNode)((Node)session.getItem(NewsletterConstant.generateUserPath(portalName)));
                    if (userFolderNode.canAddMixin("exo:privilegeable")) {
                        userFolderNode.addMixin("exo:privilegeable");
                    }
                    userFolderNode.setPermission("any", arrayPers);
                    Node newsletterInitializationServiceLog = newsletterInitializationService.addNode("NewsletterInitializationServiceLog", "nt:file");
                    Node newsletterInitializationServiceLogContent = newsletterInitializationServiceLog.addNode("jcr:content", "nt:resource");
                    newsletterInitializationServiceLogContent.setProperty("jcr:encoding", "UTF-8");
                    newsletterInitializationServiceLogContent.setProperty("jcr:mimeType", "text/plain");
                    newsletterInitializationServiceLogContent.setProperty("jcr:data", "Newsletter was created successfully");
                    newsletterInitializationServiceLogContent.setProperty("jcr:lastModified", new Date().getTime());
                    session.save();
                }
            }
        }
        catch (Throwable e) {
            log.info((Object)"Starting NewsletterInitializationService fail because of ", e);
        }
    }

    public void stop() {
        log.info((Object)"Stopping NewsletterInitializationService ... ");
    }
}

