/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.index;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.xcmis.search.lucene.index.ConcurrentDirectoryFactory;
import org.xcmis.search.lucene.index.FileSystemTransactionLog;
import org.xcmis.search.lucene.index.IndexTransactionService;
import org.xcmis.search.lucene.index.TransactionLog;
import org.xcmis.search.lucene.index.TransactionLogException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSIndexTransactionService
implements IndexTransactionService {
    private final ConcurrentDirectoryFactory lockFactory;
    private final File storageDir;

    public FSIndexTransactionService(File storageDir, ConcurrentDirectoryFactory lockFactory) {
        this.storageDir = storageDir;
        this.lockFactory = lockFactory;
    }

    public final ConcurrentDirectoryFactory getLockFactory() {
        return this.lockFactory;
    }

    public final File getStorageDir() {
        return this.storageDir;
    }

    public List<TransactionLog> getTransactionLogs() throws TransactionLogException {
        List<File> logFileList = this.getFileList(this.storageDir);
        ArrayList<TransactionLog> logs = new ArrayList<TransactionLog>();
        for (File file : logFileList) {
            FileSystemTransactionLog log = new FileSystemTransactionLog(file, this);
            logs.add(log);
        }
        return logs;
    }

    public boolean hasUncommitedTransactions() {
        return this.hasFiles(this.storageDir);
    }

    protected List<File> getFileList(File dir) {
        File[] list;
        ArrayList<File> resList = new ArrayList<File>();
        for (File file : list = dir.listFiles()) {
            if (file.isFile()) {
                resList.add(file);
                continue;
            }
            resList.addAll(this.getFileList(file));
        }
        return resList;
    }

    private boolean hasFiles(File dir) {
        if (dir.exists()) {
            File[] list;
            for (File file : list = dir.listFiles()) {
                if (file.isFile()) {
                    return true;
                }
                if (!this.hasFiles(file)) continue;
                return true;
            }
        }
        return false;
    }
}

