/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.jcr;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryBuilder {
    private StringBuilder queryBuilder;
    private long limit = -1L;
    private long offset = -1L;
    private Session session;
    private final String WHERE = " WHERE";
    public static final String DESC = "DESC";
    public static final String ASC = "ASC";

    public QueryBuilder(Session session) {
        this.session = session;
    }

    public QueryBuilder select(String selector) {
        this.queryBuilder = new StringBuilder();
        this.queryBuilder.append("SELECT * FROM ").append(selector).append(" WHERE");
        return this;
    }

    public QueryBuilder select(String selector, long offset, long count) {
        this.offset = offset;
        this.limit = count;
        return this.select(selector);
    }

    public String getSQL() {
        assert (this.queryBuilder != null);
        this.revalidateQueryBuilder();
        return this.queryBuilder.toString();
    }

    public long count() throws RepositoryException {
        assert (this.queryBuilder != null);
        ArrayList nodes = new ArrayList();
        QueryManager queryManager = this.session.getWorkspace().getQueryManager();
        QueryImpl query = (QueryImpl)queryManager.createQuery(this.getSQL(), "sql");
        if (this.offset != -1L & this.limit != -1L) {
            query.setOffset(this.offset);
            query.setLimit(this.limit);
        }
        QueryResult result = query.execute();
        return result.getNodes().getSize();
    }

    public List<Node> exec() throws RepositoryException {
        assert (this.queryBuilder != null);
        ArrayList<Node> nodes = new ArrayList<Node>();
        QueryManager queryManager = this.session.getWorkspace().getQueryManager();
        QueryImpl query = (QueryImpl)queryManager.createQuery(this.getSQL(), "sql");
        if (this.offset != -1L & this.limit != -1L) {
            query.setOffset(this.offset);
            query.setLimit(this.limit);
        }
        QueryResult result = query.execute();
        NodeIterator nodeIterator = result.getNodes();
        while (nodeIterator.hasNext()) {
            nodes.add(nodeIterator.nextNode());
        }
        return nodes;
    }

    public QueryBuilder and() {
        this.queryBuilder.append(" ").append("AND");
        return this;
    }

    public QueryBuilder or() {
        this.queryBuilder.append(" ").append("OR");
        return this;
    }

    public QueryBuilder group() {
        this.queryBuilder.append(" ").append("(");
        return this;
    }

    public QueryBuilder endGroup() {
        this.queryBuilder.append(" ").append(")");
        return this;
    }

    public QueryBuilder not() {
        this.queryBuilder.append(" ").append("NOT");
        return this;
    }

    public QueryBuilder contains(String property, String value) {
        this.queryBuilder.append(" ").append("CONTAINS(").append(property).append(", ").append("'").append(value).append("'").append(")");
        return this;
    }

    public QueryBuilder like(String property, String value) {
        this.queryBuilder.append(" ").append(property).append(" LIKE ").append("'").append(value).append("'");
        return this;
    }

    public QueryBuilder equal(String property, boolean value) {
        return this.equal(property, String.valueOf(value));
    }

    public QueryBuilder equal(String property, String value) {
        return this.appendComparison(property, "'" + value + "'", "=");
    }

    public QueryBuilder equal(String property, int value) {
        return this.appendComparison(property, value, "=");
    }

    public QueryBuilder greater(String property, int value) {
        return this.appendComparison(property, value, ">");
    }

    public QueryBuilder greaterEqual(String property, int value) {
        return this.appendComparison(property, value, ">=");
    }

    public QueryBuilder less(String property, int value) {
        return this.appendComparison(property, value, "<");
    }

    public QueryBuilder lessEqual(String property, int value) {
        return this.appendComparison(property, value, "<=");
    }

    public QueryBuilder notEqual(String property, int value) {
        return this.appendComparison(property, value, "<>");
    }

    private QueryBuilder appendComparison(String property, Object value, String comparator) {
        this.queryBuilder.append(" ").append(property).append(comparator).append(value);
        return this;
    }

    public String lower(String property) {
        return "LOWER(" + property + ")";
    }

    public String upper(String property) {
        return "UPPER(" + property + ")";
    }

    public QueryBuilder isNull(String property) {
        return this.appendComparison(property, "NULL", " IS ");
    }

    public QueryBuilder isNotNull(String property) {
        return this.appendComparison(property, "NULL", " IS NOT ");
    }

    public QueryBuilder orderBy(String property, String orderType) {
        this.revalidateQueryBuilder();
        this.queryBuilder.append(" ").append("ORDER BY ").append(property).append(" ").append(orderType);
        return this;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    private void revalidateQueryBuilder() {
        String query = this.queryBuilder.toString();
        if (query.endsWith(" WHERE")) {
            query = query.replace(" WHERE", "");
        }
        this.queryBuilder = new StringBuilder(query);
    }
}

