/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.apache.tika.detect.Detector;
import org.apache.tika.detect.XmlRootExtractor;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.Magic;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.Patterns;

public final class MimeTypes
implements Detector {
    public static final String OCTET_STREAM = "application/octet-stream";
    public static final String PLAIN_TEXT = "text/plain";
    public static final String XML = "application/xml";
    private static final boolean[] IS_CONTROL_BYTE = new boolean[32];
    private final MimeType rootMimeType;
    private final MimeType textMimeType;
    private final MimeType xmlMimeType;
    private final Map<String, MimeType> types = new HashMap<String, MimeType>();
    private Patterns patterns = new Patterns();
    private SortedSet<Magic> magics = new TreeSet<Magic>();
    private SortedSet<MimeType> xmls = new TreeSet<MimeType>();
    private final XmlRootExtractor xmlRootExtractor;

    public MimeTypes() {
        this.rootMimeType = new MimeType(this, OCTET_STREAM);
        this.textMimeType = new MimeType(this, PLAIN_TEXT);
        this.xmlMimeType = new MimeType(this, XML);
        try {
            this.textMimeType.setSuperType(this.rootMimeType);
            this.xmlMimeType.setSuperType(this.rootMimeType);
        }
        catch (MimeTypeException e) {
            throw new IllegalStateException("Error in MimeType logic", e);
        }
        this.types.put(this.rootMimeType.getName(), this.rootMimeType);
        this.types.put(this.textMimeType.getName(), this.textMimeType);
        this.types.put(this.xmlMimeType.getName(), this.xmlMimeType);
        try {
            this.xmlRootExtractor = new XmlRootExtractor();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create a XmlRootExtractor", e);
        }
    }

    public MimeType getMimeType(File file) {
        return this.getMimeType(file.getName());
    }

    public MimeType getMimeType(URL url) {
        return this.getMimeType(url.getPath());
    }

    public MimeType getMimeType(String name) {
        MimeType type = this.patterns.matches(name);
        if (type != null) {
            return type;
        }
        type = this.patterns.matches(name.toLowerCase());
        if (type != null) {
            return type;
        }
        return this.rootMimeType;
    }

    public MimeType getMimeType(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Data is missing");
        }
        MimeType result = null;
        for (Magic magic : this.magics) {
            if (!magic.eval(data)) continue;
            result = magic.getType();
            break;
        }
        if (result != null) {
            QName rootElement;
            if ((XML.equals(result.getName()) || "text/html".equals(result.getName())) && (rootElement = this.xmlRootExtractor.extractRootElement(data)) != null) {
                for (MimeType type : this.xmls) {
                    if (!type.matchesXML(rootElement.getNamespaceURI(), rootElement.getLocalPart())) continue;
                    result = type;
                    break;
                }
            }
            return result;
        }
        for (int i = 0; i < data.length; ++i) {
            int b = data[i] & 0xFF;
            if (b >= IS_CONTROL_BYTE.length || !IS_CONTROL_BYTE[b]) continue;
            return this.rootMimeType;
        }
        return this.textMimeType;
    }

    public MimeType getMimeType(InputStream stream) throws IOException {
        return this.getMimeType(this.readMagicHeader(stream));
    }

    private byte[] readMagicHeader(InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("InputStream is missing");
        }
        byte[] bytes = new byte[this.getMinLength()];
        int totalRead = 0;
        int lastRead = stream.read(bytes);
        while (lastRead != -1) {
            if ((totalRead += lastRead) == bytes.length) {
                return bytes;
            }
            lastRead = stream.read(bytes, totalRead, bytes.length - totalRead);
        }
        byte[] shorter = new byte[totalRead];
        System.arraycopy(bytes, 0, shorter, 0, totalRead);
        return shorter;
    }

    public String getType(String typeName, String url, byte[] data) {
        try {
            Metadata metadata = new Metadata();
            if (url != null) {
                metadata.set("resourceName", url);
            }
            if (typeName != null) {
                metadata.set("Content-Type", typeName);
            }
            return this.detect(new ByteArrayInputStream(data), metadata).toString();
        }
        catch (IOException e) {
            throw new IllegalStateException("ByteArrayInputStream throws an IOException!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getType(URL url) throws IOException {
        InputStream stream = url.openStream();
        try {
            Metadata metadata = new Metadata();
            metadata.set("resourceName", url.toString());
            String string = this.detect(stream, metadata).toString();
            return string;
        }
        finally {
            stream.close();
        }
    }

    public MimeType getMimeType(String name, byte[] data) {
        MimeType mimeType = this.getMimeType(data);
        if (mimeType == null) {
            mimeType = this.getMimeType(name);
        }
        return mimeType;
    }

    public MimeType getMimeType(String name, InputStream stream) throws IOException {
        return this.getMimeType(name, this.readMagicHeader(stream));
    }

    public synchronized MimeType forName(String name) throws MimeTypeException {
        if (MimeType.isValid(name)) {
            MimeType type = this.types.get(name = name.toLowerCase());
            if (type == null) {
                type = new MimeType(this, name);
                if (name.startsWith("text/")) {
                    type.setSuperType(this.textMimeType);
                } else if (name.endsWith("+xml")) {
                    type.setSuperType(this.xmlMimeType);
                } else {
                    type.setSuperType(this.rootMimeType);
                }
                this.types.put(name, type);
            }
            return type;
        }
        throw new MimeTypeException("Invalid media type name: " + name);
    }

    synchronized void addAlias(MimeType type, String alias) throws MimeTypeException {
        if (this.types.containsKey(alias)) {
            throw new MimeTypeException("Media type alias already exists: " + alias);
        }
        this.types.put(alias, type);
    }

    public void addPattern(MimeType type, String pattern) throws MimeTypeException {
        this.addPattern(type, pattern, false);
    }

    public void addPattern(MimeType type, String pattern, boolean isRegex) throws MimeTypeException {
        this.patterns.add(pattern, isRegex, type);
    }

    public int getMinLength() {
        return 8192;
    }

    void add(MimeType type) {
        if (type.hasMagic()) {
            this.magics.addAll(Arrays.asList(type.getMagics()));
        }
        if (type.hasRootXML()) {
            this.xmls.add(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        String typeName;
        MimeType hint;
        String resourceName;
        MimeType type = this.rootMimeType;
        if (input != null) {
            input.mark(this.getMinLength());
            try {
                byte[] prefix = this.readMagicHeader(input);
                type = this.getMimeType(prefix);
            }
            finally {
                input.reset();
            }
        }
        if ((resourceName = metadata.get("resourceName")) != null) {
            String name = null;
            try {
                int slash;
                URI uri = new URI(resourceName);
                String path = uri.getPath();
                if (path != null && (slash = path.lastIndexOf(47)) + 1 < path.length()) {
                    name = path.substring(slash + 1);
                }
            }
            catch (URISyntaxException e) {
                name = resourceName;
            }
            if (name != null && (hint = this.getMimeType(name)).isDescendantOf(type)) {
                type = hint;
            }
        }
        if ((typeName = metadata.get("Content-Type")) != null) {
            try {
                hint = this.forName(typeName);
                if (hint.isDescendantOf(type)) {
                    type = hint;
                }
            }
            catch (MimeTypeException e) {
                // empty catch block
            }
        }
        return MediaType.parse(type.getName());
    }

    static {
        Arrays.fill(IS_CONTROL_BYTE, true);
        MimeTypes.IS_CONTROL_BYTE[9] = false;
        MimeTypes.IS_CONTROL_BYTE[10] = false;
        MimeTypes.IS_CONTROL_BYTE[12] = false;
        MimeTypes.IS_CONTROL_BYTE[13] = false;
        MimeTypes.IS_CONTROL_BYTE[27] = false;
    }
}

