/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import javax.transaction.Transaction;
import org.jboss.cache.Fqn;
import org.jboss.cache.commands.DataCommand;

public class EvictionEvent {
    private Fqn fqn;
    private Type type;
    private int elementDifference;
    private long inUseTimeout;
    private long creationTimestamp;
    private DataCommand command;
    private Transaction transaction;

    public EvictionEvent() {
    }

    public EvictionEvent(Fqn fqn, Type type, int elementDifference, DataCommand command, Transaction tx) {
        this.fqn = fqn;
        this.type = type;
        this.elementDifference = elementDifference;
        this.creationTimestamp = System.currentTimeMillis();
        this.command = command;
        this.transaction = tx;
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public long getInUseTimeout() {
        return this.inUseTimeout;
    }

    public void setInUseTimeout(long inUseTimeout) {
        this.inUseTimeout = inUseTimeout;
    }

    public int getElementDifference() {
        return this.elementDifference;
    }

    public void setElementDifference(int elementDifference) {
        this.elementDifference = elementDifference;
    }

    public Fqn getFqn() {
        return this.fqn;
    }

    public void setFqn(Fqn fqn) {
        this.fqn = fqn;
    }

    public void setEventType(Type event) {
        this.type = event;
    }

    public Type getEventType() {
        return this.type;
    }

    public DataCommand getCommand() {
        return this.command;
    }

    public void setCommand(DataCommand command) {
        this.command = command;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    public String toString() {
        return "EvictedEventNode[fqn=" + this.fqn + " event=" + (Object)((Object)this.type) + " diff=" + this.elementDifference + "]";
    }

    public EvictionEvent copy(Fqn newRoot) {
        return new EvictionEvent(Fqn.fromRelativeFqn(newRoot, this.fqn), this.type, this.elementDifference, this.command, this.transaction);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ADD_NODE_EVENT,
        REMOVE_NODE_EVENT,
        VISIT_NODE_EVENT,
        ADD_ELEMENT_EVENT,
        REMOVE_ELEMENT_EVENT,
        MARK_IN_USE_EVENT,
        UNMARK_USE_EVENT;

    }
}

