/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.buddyreplication.BuddyFqnTransformer;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.buddyreplication.GravitateResult;
import org.jboss.cache.commands.CommandsFactory;
import org.jboss.cache.commands.DataCommand;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.commands.VisitableCommand;
import org.jboss.cache.commands.read.GetChildrenNamesCommand;
import org.jboss.cache.commands.read.GetDataMapCommand;
import org.jboss.cache.commands.read.GetKeyValueCommand;
import org.jboss.cache.commands.read.GetKeysCommand;
import org.jboss.cache.commands.read.GetNodeCommand;
import org.jboss.cache.commands.read.GravitateDataCommand;
import org.jboss.cache.commands.remote.DataGravitationCleanupCommand;
import org.jboss.cache.commands.tx.CommitCommand;
import org.jboss.cache.commands.tx.OptimisticPrepareCommand;
import org.jboss.cache.commands.tx.PrepareCommand;
import org.jboss.cache.commands.tx.RollbackCommand;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.interceptors.BaseRpcInterceptor;
import org.jboss.cache.marshall.NodeData;
import org.jboss.cache.marshall.RequestIgnoredResponse;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jgroups.Address;
import org.jgroups.blocks.RspFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class LegacyDataGravitatorInterceptor
extends BaseRpcInterceptor {
    private BuddyManager buddyManager;
    private Map<GlobalTransaction, List<ReplicableCommand>> cleanupCommands = new ConcurrentHashMap<GlobalTransaction, List<ReplicableCommand>>();
    private DataContainer dataContainer;
    private CommandsFactory commandsFactory;
    private CacheSPI cacheSPI;
    private BuddyFqnTransformer buddyFqnTransformer;

    @Inject
    public void injectComponents(BuddyManager buddyManager, DataContainer dataContainer, CommandsFactory commandsFactory, CacheSPI cacheSPI, BuddyFqnTransformer transformer) {
        this.buddyManager = buddyManager;
        this.dataContainer = dataContainer;
        this.commandsFactory = commandsFactory;
        this.cacheSPI = cacheSPI;
        this.buddyFqnTransformer = transformer;
    }

    @Override
    public Object visitGetChildrenNamesCommand(InvocationContext ctx, GetChildrenNamesCommand command) throws Throwable {
        return this.handleGetMethod(ctx, command);
    }

    @Override
    public Object visitGetDataMapCommand(InvocationContext ctx, GetDataMapCommand command) throws Throwable {
        return this.handleGetMethod(ctx, command);
    }

    @Override
    public Object visitGetKeysCommand(InvocationContext ctx, GetKeysCommand command) throws Throwable {
        return this.handleGetMethod(ctx, command);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.handleGetMethod(ctx, command);
    }

    @Override
    public Object visitGetNodeCommand(InvocationContext ctx, GetNodeCommand command) throws Throwable {
        return this.handleGetMethod(ctx, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitRollbackCommand(InvocationContext ctx, RollbackCommand command) throws Throwable {
        try {
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.cleanupCommands.remove(ctx.getGlobalTransaction());
        }
    }

    @Override
    public Object visitPrepareCommand(InvocationContext ctx, PrepareCommand command) throws Throwable {
        if (command.isOnePhaseCommit()) {
            return this.dataGravitationCleanupOnCommit(ctx, command);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitCommitCommand(InvocationContext ctx, CommitCommand command) throws Throwable {
        return this.dataGravitationCleanupOnCommit(ctx, command);
    }

    @Override
    public Object visitOptimisticPrepareCommand(InvocationContext ctx, OptimisticPrepareCommand command) throws Throwable {
        return this.visitPrepareCommand(ctx, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object dataGravitationCleanupOnCommit(InvocationContext ctx, VisitableCommand command) throws Throwable {
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        try {
            this.doCommit(gtx);
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.cleanupCommands.remove(gtx);
        }
    }

    protected boolean nodeDoesNotExist(InvocationContext ctx, Fqn fqn) {
        return !this.dataContainer.exists(fqn);
    }

    private Object handleGetMethod(InvocationContext ctx, DataCommand command) throws Throwable {
        if (this.isGravitationEnabled(ctx)) {
            if (this.trace) {
                this.log.trace((Object)("Checking local existence of requested fqn " + command.getFqn()));
            }
            if (BuddyFqnTransformer.isBackupFqn(command.getFqn())) {
                this.log.info((Object)"Is call for a backup Fqn, not performing any gravitation.  Direct calls on internal backup nodes are *not* supported.");
            } else if (this.nodeDoesNotExist(ctx, command.getFqn())) {
                BackupData data;
                if (this.trace) {
                    this.log.trace((Object)"Gravitating from local backup tree");
                }
                if ((data = this.localBackupGet(command.getFqn(), ctx)) == null) {
                    if (this.trace) {
                        this.log.trace((Object)"Gravitating from remote backup tree");
                    }
                    data = this.remoteBackupGet(command.getFqn());
                }
                if (data != null) {
                    if (this.trace) {
                        this.log.trace((Object)"Passing the put call locally to make sure state is persisted and ownership is correctly established.");
                    }
                    this.createNode(data.backupData);
                    this.cleanBackupData(data, ctx);
                    this.wrapIfNeeded(ctx, data.primaryFqn);
                }
            } else if (this.trace) {
                this.log.trace((Object)"No need to gravitate; have this already.");
            }
        } else if (this.trace) {
            this.log.trace((Object)"Suppressing data gravitation for this call.");
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    protected void wrapIfNeeded(InvocationContext ctx, Fqn fqnToWrap) throws InterruptedException {
    }

    private boolean isGravitationEnabled(InvocationContext ctx) {
        boolean enabled = ctx.isOriginLocal();
        if (enabled && !this.buddyManager.isAutoDataGravitation()) {
            enabled = ctx.getOptionOverrides().getForceDataGravitation();
        }
        return enabled;
    }

    private void doCommit(GlobalTransaction gtx) throws Throwable {
        if (this.cleanupCommands.containsKey(gtx)) {
            if (this.trace) {
                this.log.trace((Object)("Broadcasting cleanup commands for gtx " + gtx));
            }
            for (ReplicableCommand command : this.cleanupCommands.get(gtx)) {
                try {
                    this.doCleanup(command);
                }
                catch (Throwable th) {
                    this.log.warn((Object)("Problems performing gravitation cleanup.  Cleanup command: " + command), th);
                }
            }
        } else if (this.trace) {
            this.log.trace((Object)("No cleanups to broadcast in commit phase for gtx " + gtx));
        }
    }

    private BackupData remoteBackupGet(Fqn name) throws Exception {
        BackupData result = null;
        GravitateResult gr = this.gravitateData(name);
        if (gr.isDataFound()) {
            if (this.trace) {
                this.log.trace((Object)("Got response " + gr));
            }
            result = new BackupData(name, gr);
        }
        return result;
    }

    private void cleanBackupData(BackupData backup, InvocationContext ctx) throws Throwable {
        DataGravitationCleanupCommand cleanupCommand = this.commandsFactory.buildDataGravitationCleanupCommand(backup.primaryFqn, backup.backupFqn);
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        if (gtx == null) {
            if (this.trace) {
                this.log.trace((Object)("Performing cleanup on [" + backup.primaryFqn + "]"));
            }
            this.doCleanup(cleanupCommand);
        } else {
            if (this.trace) {
                this.log.trace((Object)("Data gravitation performed under global transaction " + gtx + ".  Not broadcasting cleanups until the tx commits.  Recording cleanup command for later use."));
            }
            List<ReplicableCommand> commands = this.cleanupCommands.containsKey(gtx) ? this.cleanupCommands.get(gtx) : new LinkedList<DataGravitationCleanupCommand>();
            commands.add(cleanupCommand);
            this.cleanupCommands.put(gtx, commands);
        }
    }

    private void doCleanup(ReplicableCommand cleanupCommand) throws Throwable {
        this.replicateCall(null, cleanupCommand, false, false, false, true, -1L);
    }

    private GravitateResult gravitateData(Fqn fqn) throws Exception {
        if (this.trace) {
            this.log.trace((Object)("Requesting data gravitation for Fqn " + fqn));
        }
        List<Address> mbrs = this.rpcManager.getMembers();
        Boolean searchSubtrees = this.buddyManager.isDataGravitationSearchBackupTrees();
        GravitateDataCommand command = this.commandsFactory.buildGravitateDataCommand(fqn, searchSubtrees);
        List<Object> resps = this.rpcManager.callRemoteMethods(null, command, 2, this.buddyManager.getBuddyCommunicationTimeout(), new ResponseValidityFilter(this.rpcManager.getMembers().size()), false);
        if (this.trace) {
            this.log.trace((Object)("got responses " + resps));
        }
        if (resps == null) {
            if (mbrs.size() > 1) {
                this.log.error((Object)("No replies to call " + command));
            }
            return GravitateResult.noDataFound();
        }
        GravitateResult result = GravitateResult.noDataFound();
        for (Object o : resps) {
            if (o instanceof Throwable) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)"Found remote Throwable among responses - removing from responses list", (Throwable)((Exception)o));
                continue;
            }
            if (o instanceof GravitateResult) {
                GravitateResult candidate = (GravitateResult)o;
                if (!this.isPreferable(candidate, result)) continue;
                result = candidate;
                continue;
            }
            if (o == null) {
                if (this.configuration.isUseRegionBasedMarshalling()) continue;
                this.log.error((Object)("Unexpected null response to call " + command + "."));
                continue;
            }
            if (o instanceof RequestIgnoredResponse) continue;
            this.log.error((Object)("Unexpected response " + o + " to call " + command + "."));
        }
        return result;
    }

    private boolean isPreferable(GravitateResult candidate, GravitateResult existing) {
        String candidateOwner;
        String existingOwner;
        if (!existing.isDataFound()) {
            return true;
        }
        if (!candidate.isDataFound()) {
            return false;
        }
        int ownerIndex = BuddyManager.BUDDY_BACKUP_SUBTREE_FQN.size();
        Fqn existingFqn = existing.getBuddyBackupFqn();
        String string = existingOwner = existingFqn.size() > ownerIndex ? (String)existingFqn.get(ownerIndex) : null;
        if (existingOwner == null) {
            return true;
        }
        boolean existingDead = existingOwner.endsWith(":DEAD");
        Fqn candidateFqn = candidate.getBuddyBackupFqn();
        String string2 = candidateOwner = candidateFqn.size() > ownerIndex ? (String)candidateFqn.get(ownerIndex) : null;
        if (candidateOwner == null) {
            this.log.warn((Object)("Could not find a data owner in backupFqn from " + candidate));
            return false;
        }
        if (candidateOwner.endsWith(":DEAD")) {
            if (existingDead) {
                if (candidateOwner.equals(existingOwner)) {
                    Object candGen;
                    Object existGen;
                    int genIndex = ownerIndex + 1;
                    Object object = existGen = existingFqn.size() > genIndex ? existingFqn.get(genIndex) : null;
                    if (!(existGen instanceof Integer)) {
                        return true;
                    }
                    Object object2 = candGen = candidateFqn.size() > genIndex ? candidateFqn.get(genIndex) : null;
                    if (!(candGen instanceof Integer)) {
                        this.log.warn((Object)("Could not find a dead data owner generation in backupFqn from " + candidate));
                        return false;
                    }
                    return (Integer)candGen > (Integer)existGen;
                }
                return false;
            }
            return false;
        }
        return existingDead;
    }

    private void createNode(List<NodeData> nodeData) throws CacheException {
        for (NodeData data : nodeData) {
            this.cacheSPI.put(data.getFqn(), data.getAttributes());
        }
    }

    private BackupData localBackupGet(Fqn fqn, InvocationContext ctx) throws CacheException {
        GravitateResult result = this.cacheSPI.gravitateData(fqn, true, ctx);
        boolean found = result.isDataFound();
        BackupData data = null;
        if (found) {
            Fqn backupFqn = result.getBuddyBackupFqn();
            data = new BackupData(fqn, result);
            if (this.buddyManager.isDataGravitationRemoveOnFind()) {
                ctx.getOptionOverrides().setCacheModeLocal(true);
                this.cacheSPI.removeNode(backupFqn);
            } else {
                this.cacheSPI.evict(backupFqn, true);
            }
        }
        if (this.trace) {
            this.log.trace((Object)("Retrieved data " + data + " found = " + found));
        }
        return data;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GravitationResponseComparator
    implements Comparator<Object> {
        private GravitationResponseComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof GravitateResult) {
                if (o2 instanceof GravitateResult) {
                    GravitateResult g2 = (GravitateResult)o2;
                    if (!g2.isDataFound()) {
                        return -1;
                    }
                    return this.comparePositiveResults((GravitateResult)o1, g2);
                }
                return -1;
            }
            return 1;
        }

        private int comparePositiveResults(GravitateResult g1, GravitateResult g2) {
            Fqn f1 = g1.getBuddyBackupFqn();
            Fqn f2 = g2.getBuddyBackupFqn();
            return -1;
        }
    }

    public static class ResponseValidityFilter
    implements RspFilter {
        int memberCount;

        public ResponseValidityFilter(int memberCount) {
            this.memberCount = memberCount;
        }

        public boolean isAcceptable(Object object, Address address) {
            if (object instanceof GravitateResult) {
                --this.memberCount;
            }
            return true;
        }

        public boolean needMoreResponses() {
            return this.memberCount > 1;
        }
    }

    private static class BackupData {
        Fqn primaryFqn;
        Fqn backupFqn;
        List<NodeData> backupData;

        public BackupData(Fqn primaryFqn, GravitateResult gr) {
            this.primaryFqn = primaryFqn;
            this.backupFqn = gr.getBuddyBackupFqn();
            this.backupData = gr.getNodeData();
        }

        public String toString() {
            return "BackupData{primaryFqn=" + this.primaryFqn + ", backupFqn=" + this.backupFqn + ", backupData=" + this.backupData + '}';
        }
    }
}

