/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.common;

import java.io.File;
import java.io.FileFilter;

public class FileFilterByExt
implements FileFilter {
    private String[] exts = new String[0];
    private boolean isFile = false;

    public FileFilterByExt() {
    }

    public FileFilterByExt(boolean isFile_) {
        this.isFile = isFile_;
    }

    public FileFilterByExt(String[] exts_) {
        this.exts = new String[exts_.length];
        for (int i = 0; i < exts_.length; ++i) {
            if (exts_[i] == null) continue;
            this.exts[i] = exts_[i].trim().toLowerCase();
        }
    }

    public FileFilterByExt(String ext) {
        this.exts = new String[]{ext.trim().toLowerCase()};
    }

    public boolean accept(File f) {
        if (this.exts.length == 0 && !this.isFile) {
            return f.isDirectory();
        }
        if (this.exts.length == 0 && this.isFile && f.isFile()) {
            return f.getName().indexOf(".") < 0;
        }
        if (f.isDirectory()) {
            return false;
        }
        return this.isEndWith(f.getName());
    }

    private boolean isEndWith(String name) {
        name = name.trim().toLowerCase();
        for (String ele : this.exts) {
            if (ele == null || !name.endsWith(ele)) continue;
            return true;
        }
        return false;
    }
}

