/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.x509;

import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.LDAPCertStoreParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bouncycastle.jce.X509LDAPCertStoreParameters;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.bouncycastle.x509.PKIXAttrCertChecker;
import org.bouncycastle.x509.X509CertStoreSelector;
import org.bouncycastle.x509.X509CollectionStoreParameters;
import org.bouncycastle.x509.X509Store;
import org.bouncycastle.x509.X509StoreParameters;

public class ExtendedPKIXParameters
extends PKIXParameters {
    private List stores = new ArrayList();
    private Selector selector;
    private boolean additionalLocationsEnabled = false;
    private List additionalStores = new ArrayList();
    private Set trustedACIssuers = new HashSet();
    private Set necessaryACAttributes = new HashSet();
    private Set prohibitedACAttributes = new HashSet();
    private Set attrCertCheckers = new HashSet();
    public static final int PKIX_VALIDITY_MODEL = 0;
    public static final int CHAIN_VALIDITY_MODEL = 1;
    private int validityModel = 0;
    private boolean useDeltas = false;
    static /* synthetic */ Class class$java$security$cert$TrustAnchor;
    static /* synthetic */ Class class$org$bouncycastle$x509$PKIXAttrCertChecker;

    public ExtendedPKIXParameters(Set set) throws InvalidAlgorithmParameterException {
        super(set);
    }

    public static ExtendedPKIXParameters getInstance(PKIXParameters pKIXParameters) {
        ExtendedPKIXParameters extendedPKIXParameters = null;
        try {
            extendedPKIXParameters = new ExtendedPKIXParameters((Set)pKIXParameters.getTrustAnchors());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        extendedPKIXParameters.setParams(pKIXParameters);
        return extendedPKIXParameters;
    }

    protected void setParams(PKIXParameters pKIXParameters) {
        this.setDate(pKIXParameters.getDate());
        this.setCertPathCheckers(pKIXParameters.getCertPathCheckers());
        this.setCertStores((List)pKIXParameters.getCertStores());
        this.setAnyPolicyInhibited(pKIXParameters.isAnyPolicyInhibited());
        this.setExplicitPolicyRequired(pKIXParameters.isExplicitPolicyRequired());
        this.setPolicyMappingInhibited(pKIXParameters.isPolicyMappingInhibited());
        this.setRevocationEnabled(pKIXParameters.isRevocationEnabled());
        this.setInitialPolicies(pKIXParameters.getInitialPolicies());
        this.setPolicyQualifiersRejected(pKIXParameters.getPolicyQualifiersRejected());
        this.setSigProvider(pKIXParameters.getSigProvider());
        this.setTargetCertConstraints(pKIXParameters.getTargetCertConstraints());
        try {
            this.setTrustAnchors(pKIXParameters.getTrustAnchors());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        if (pKIXParameters instanceof ExtendedPKIXParameters) {
            ExtendedPKIXParameters extendedPKIXParameters = (ExtendedPKIXParameters)pKIXParameters;
            this.validityModel = extendedPKIXParameters.validityModel;
            this.useDeltas = extendedPKIXParameters.useDeltas;
            this.additionalLocationsEnabled = extendedPKIXParameters.additionalLocationsEnabled;
            this.selector = extendedPKIXParameters.selector == null ? null : (Selector)extendedPKIXParameters.selector.clone();
            this.stores = new ArrayList(extendedPKIXParameters.stores);
            this.additionalStores = new ArrayList(extendedPKIXParameters.additionalStores);
            this.trustedACIssuers = new HashSet(extendedPKIXParameters.trustedACIssuers);
            this.prohibitedACAttributes = new HashSet(extendedPKIXParameters.prohibitedACAttributes);
            this.necessaryACAttributes = new HashSet(extendedPKIXParameters.necessaryACAttributes);
            this.attrCertCheckers = new HashSet(extendedPKIXParameters.attrCertCheckers);
        }
    }

    public boolean isUseDeltasEnabled() {
        return this.useDeltas;
    }

    public void setUseDeltasEnabled(boolean bl) {
        this.useDeltas = bl;
    }

    public int getValidityModel() {
        return this.validityModel;
    }

    public void addCertStore(CertStore certStore) {
        Object object;
        super.addCertStore(certStore);
        if (certStore.getCertStoreParameters() instanceof CollectionCertStoreParameters) {
            object = ((CollectionCertStoreParameters)certStore.getCertStoreParameters()).getCollection();
            X509CollectionStoreParameters x509CollectionStoreParameters = new X509CollectionStoreParameters((Collection)object);
            try {
                this.stores.add(X509Store.getInstance("CERTIFICATE/COLLECTION", (X509StoreParameters)x509CollectionStoreParameters, "BC"));
                this.stores.add(X509Store.getInstance("CRL/COLLECTION", (X509StoreParameters)x509CollectionStoreParameters, "BC"));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }
        if (certStore.getCertStoreParameters() instanceof LDAPCertStoreParameters || certStore.getCertStoreParameters() instanceof X509LDAPCertStoreParameters) {
            object = null;
            if (certStore.getCertStoreParameters() instanceof X509LDAPCertStoreParameters) {
                object = (X509LDAPCertStoreParameters)certStore.getCertStoreParameters();
            } else {
                int n = ((LDAPCertStoreParameters)certStore.getCertStoreParameters()).getPort();
                String string = ((LDAPCertStoreParameters)certStore.getCertStoreParameters()).getServerName();
                object = new X509LDAPCertStoreParameters.Builder("ldap://" + string + ":" + n, null).build();
            }
            try {
                this.stores.add(X509Store.getInstance("CERTIFICATE/LDAP", (X509StoreParameters)object, "BC"));
                this.stores.add(X509Store.getInstance("CRL/LDAP", (X509StoreParameters)object, "BC"));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }
    }

    public void setCertStores(List list) {
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.addCertStore((CertStore)iterator.next());
            }
        }
    }

    public void setStores(List list) {
        if (list == null) {
            this.stores = new ArrayList();
        } else {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() instanceof Store) continue;
                throw new ClassCastException("All elements of list must be of type org.bouncycastle.util.Store.");
            }
            this.stores = new ArrayList(list);
        }
    }

    public void addStore(Store store) {
        if (this.stores != null) {
            this.stores.add(store);
        }
    }

    public void addAddionalStore(Store store) {
        if (store != null) {
            this.additionalStores.add(store);
        }
    }

    public List getAddionalStores() {
        return Collections.unmodifiableList(this.additionalStores);
    }

    public List getStores() {
        return Collections.unmodifiableList(new ArrayList(this.stores));
    }

    public void setValidityModel(int n) {
        this.validityModel = n;
    }

    public Object clone() {
        ExtendedPKIXParameters extendedPKIXParameters = null;
        try {
            extendedPKIXParameters = new ExtendedPKIXParameters((Set)this.getTrustAnchors());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        extendedPKIXParameters.setParams(this);
        return extendedPKIXParameters;
    }

    public boolean isAdditionalLocationsEnabled() {
        return this.additionalLocationsEnabled;
    }

    public void setAdditionalLocationsEnabled(boolean bl) {
        this.additionalLocationsEnabled = bl;
    }

    public Selector getTargetConstraints() {
        if (this.selector != null) {
            return (Selector)this.selector.clone();
        }
        return null;
    }

    public void setTargetConstraints(Selector selector) {
        this.selector = selector != null ? (Selector)selector.clone() : null;
    }

    public void setTargetCertConstraints(CertSelector certSelector) {
        super.setTargetCertConstraints(certSelector);
        this.selector = certSelector != null ? X509CertStoreSelector.getInstance((X509CertSelector)certSelector) : null;
    }

    public Set getTrustedACIssuers() {
        return Collections.unmodifiableSet(this.trustedACIssuers);
    }

    public void setTrustedACIssuers(Set set) {
        if (set == null) {
            set.clear();
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof TrustAnchor) continue;
            throw new ClassCastException("All elements of set must be of type " + (class$java$security$cert$TrustAnchor == null ? (class$java$security$cert$TrustAnchor = ExtendedPKIXParameters.class$("java.security.cert.TrustAnchor")) : class$java$security$cert$TrustAnchor).getName() + ".");
        }
        this.trustedACIssuers.clear();
        this.trustedACIssuers.addAll(set);
    }

    public Set getNecessaryACAttributes() {
        return Collections.unmodifiableSet(this.necessaryACAttributes);
    }

    public void setNecessaryACAttributes(Set set) {
        if (set == null) {
            this.necessaryACAttributes.clear();
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof String) continue;
            throw new ClassCastException("All elements of set must be of type String.");
        }
        this.necessaryACAttributes.clear();
        this.necessaryACAttributes.addAll(set);
    }

    public Set getProhibitedACAttributes() {
        return this.prohibitedACAttributes;
    }

    public void setProhibitedACAttributes(Set set) {
        if (set == null) {
            this.prohibitedACAttributes.clear();
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof String) continue;
            throw new ClassCastException("All elements of set must be of type String.");
        }
        this.prohibitedACAttributes.clear();
        this.prohibitedACAttributes.addAll(set);
    }

    public Set getAttrCertCheckers() {
        return Collections.unmodifiableSet(this.attrCertCheckers);
    }

    public void setAttrCertCheckers(Set set) {
        if (set == null) {
            this.attrCertCheckers.clear();
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof PKIXAttrCertChecker) continue;
            throw new ClassCastException("All elements of set must be of type " + (class$org$bouncycastle$x509$PKIXAttrCertChecker == null ? (class$org$bouncycastle$x509$PKIXAttrCertChecker = ExtendedPKIXParameters.class$("org.bouncycastle.x509.PKIXAttrCertChecker")) : class$org$bouncycastle$x509$PKIXAttrCertChecker).getName() + ".");
        }
        this.attrCertCheckers.clear();
        this.attrCertCheckers.addAll(set);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

