/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xmpp.history.impl.jcr;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.xmpp.history.HistoricalMessage;
import org.exoplatform.services.xmpp.history.Interlocutor;
import org.exoplatform.services.xmpp.history.impl.jcr.Conversation;
import org.exoplatform.services.xmpp.history.impl.jcr.HistoricalMessageImpl;
import org.exoplatform.services.xmpp.history.impl.jcr.InterlocutorImpl;
import org.exoplatform.services.xmpp.history.impl.jcr.Participant;
import org.exoplatform.services.xmpp.history.impl.jcr.PresenceStatus;
import org.exoplatform.services.xmpp.util.CodingUtils;
import org.jcrom.Jcrom;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.util.StringUtils;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryImpl
implements Startable {
    private static final String CONVERSATIONS = "conversations".intern();
    private static final String PARTICIPANTS = "participants".intern();
    private static final String PARTICIPANTS_NT = "lr:participantschat".intern();
    private static final String CONVERSATIONS_NT = "lr:conversations".intern();
    private static final String HISTORICAL_MESSAGE_NT = "lr:historicalmessage".intern();
    private static final String LR_MESSAGE_DATESEND = "lr:messagedateSend";
    private static final String LR_MESSAGE_TO = "lr:messageto";
    private static final String LR_MESSAGE_RECIEVE = "lr:messagereceive";
    private static final String HISTORY_NT = "lr:chathistory";
    private static final String CONFIG_NAME = "history-conf";
    private static final String APPLICATION = "eXoChat";
    private static final String DEFAULTPRESENCESTATUS_NT = "lr:defaultpresencestatus".intern();
    private static final String DEFAULTPRESENCESTATUS = "defaultpresencestatus".intern();
    private String historyPath;
    private String wsName;
    private RepositoryService repositoryService;
    private Jcrom jcrom;
    private Queue<HistoricalMessage> logQueue = new ConcurrentLinkedQueue<HistoricalMessage>();
    Log log = ExoLogger.getExoLogger(this.getClass());

    public void start() {
        try {
            Session sysSession = this.repositoryService.getCurrentRepository().getSystemSession(this.wsName);
            this.initNodes(sysSession);
            this.jcrom = new Jcrom();
            this.jcrom.map(HistoricalMessageImpl.class);
            this.jcrom.map(Conversation.class);
            this.jcrom.map(InterlocutorImpl.class);
            this.jcrom.map(Participant.class);
            this.jcrom.map(PresenceStatus.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        this.logAllMessages();
    }

    public HistoryImpl(InitParams initParams, RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
        this.historyPath = initParams.getValueParam("path").getValue();
        this.wsName = initParams.getValueParam("workspace").getValue();
    }

    private void initNodes(Session sysSession) throws RepositoryException, RepositoryConfigurationException {
        Node node = sysSession.getRootNode();
        if (!node.hasNode(this.historyPath)) {
            String[] path = this.historyPath.split("/");
            for (int i = 0; i < path.length - 1; ++i) {
                Node tmpNode = node.hasNode(path[i]) ? node.getNode(path[i]) : node.addNode(path[i]);
                node = tmpNode;
            }
            Node fNode = node.addNode(path[path.length - 1], HISTORY_NT);
            NodeImpl cNode = (NodeImpl)fNode.addNode(CONVERSATIONS, CONVERSATIONS_NT);
            if (cNode.canAddMixin("exo:privilegeable")) {
                cNode.addMixin("exo:privilegeable");
            }
            String[] perm = new String[]{"add_node", "read", "set_property", "remove"};
            cNode.setPermission(SystemIdentity.ANY, PermissionType.ALL);
            NodeImpl pNode = (NodeImpl)fNode.addNode(PARTICIPANTS, PARTICIPANTS_NT);
            if (pNode.canAddMixin("exo:privilegeable")) {
                pNode.addMixin("exo:privilegeable");
            }
            pNode.setPermission(SystemIdentity.ANY, PermissionType.ALL);
            NodeImpl dps = (NodeImpl)fNode.addNode(DEFAULTPRESENCESTATUS, DEFAULTPRESENCESTATUS_NT);
            if (dps.canAddMixin("exo:privilegeable")) {
                dps.addMixin("exo:privilegeable");
            }
            dps.setPermission(SystemIdentity.ANY, PermissionType.ALL);
            sysSession.save();
        }
        sysSession.logout();
    }

    public Queue<HistoricalMessage> getLogQueue() {
        return this.logQueue;
    }

    public void logMessage(HistoricalMessage message) {
        if (message.getBody() != null) {
            this.logQueue.add(message);
        }
    }

    private void logAllMessages() {
        SessionProvider provider = SessionProvider.createSystemProvider();
        while (!this.logQueue.isEmpty()) {
            HistoricalMessage message = this.logQueue.poll();
            if (message == null) continue;
            this.addHistoricalMessage(message, provider);
        }
        provider.close();
    }

    public ManageableRepository getRepository() throws RepositoryException, RepositoryConfigurationException {
        return this.repositoryService.getCurrentRepository();
    }

    public String getWorkspace() {
        return this.wsName;
    }

    public boolean addHistoricalMessage(HistoricalMessage message, SessionProvider sessionProvider) {
        if (message.getTo() != null && message.getFrom() != null) {
            try {
                HistoricalMessageImpl historicalMessage = (HistoricalMessageImpl)message;
                Date date = Calendar.getInstance().getTime();
                String usernameTo = StringUtils.parseName((String)historicalMessage.getTo());
                String usernameFrom = StringUtils.parseName((String)historicalMessage.getFrom());
                String conversationId = new String();
                Boolean isGroupChat = historicalMessage.getType().equals(Message.Type.groupchat.name());
                Node conversationNode = this.getConversationsNode(sessionProvider);
                Node participantsNode = this.getParticipantsNode(sessionProvider);
                Conversation conversation = this.getConversation(conversationNode, participantsNode, usernameTo, usernameFrom, isGroupChat, true);
                if (conversation != null) {
                    conversation.addMessage(historicalMessage);
                    conversation.setLastActiveDate(date);
                    this.updateConversation(conversationNode, conversation, usernameTo);
                } else {
                    conversationId = CodingUtils.encodeToHex(UUID.randomUUID().toString());
                    this.createNewConversation(conversationNode, participantsNode, conversationId, date, historicalMessage);
                }
                conversationNode.getSession().save();
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public List<HistoricalMessage> getHistoricalMessages(String usernameTo, String usernameFrom, Boolean isGroupChat, SessionProvider sessionProvider) {
        ArrayList<HistoricalMessage> list = new ArrayList<HistoricalMessage>();
        try {
            Node conversationsNode = this.getConversationsNode(sessionProvider);
            Node participantsNode = this.getParticipantsNode(sessionProvider);
            Conversation conversation = this.getConversation(conversationsNode, participantsNode, usernameTo, usernameFrom, isGroupChat, true);
            if (conversation != null) {
                list.addAll(conversation.getMessageList());
                list.addAll(this.getHistoricalMessagesFromCache(usernameTo, usernameFrom, null, null));
                return list;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public List<HistoricalMessage> getHistoricalMessages(String usernameTo, String usernameFrom, Boolean isGroupChat, Date dateFrom, SessionProvider sessionProvider) {
        ArrayList<HistoricalMessage> list = new ArrayList<HistoricalMessage>();
        try {
            Node conversationsNode = this.getConversationsNode(sessionProvider);
            Node participantsNode = this.getParticipantsNode(sessionProvider);
            Conversation conversation = this.getConversation(conversationsNode, participantsNode, usernameTo, usernameFrom, isGroupChat, true);
            if (conversation != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(dateFrom);
                String dateFromStr = ISO8601.format((Calendar)calendar);
                Node node = conversationsNode.getNode(conversation.getConversationId());
                String sql = "SELECT * FROM " + HISTORICAL_MESSAGE_NT + " WHERE jcr:path LIKE '" + node.getPath() + "/%' " + " AND " + LR_MESSAGE_DATESEND + " > TIMESTAMP '" + dateFromStr + "' order by " + LR_MESSAGE_DATESEND;
                QueryManager queryManager = node.getSession().getWorkspace().getQueryManager();
                Query query = queryManager.createQuery(sql, "sql");
                QueryResult queryResult = query.execute();
                NodeIterator nodeIterator = queryResult.getNodes();
                while (nodeIterator.hasNext()) {
                    Node msgNode = (Node)nodeIterator.next();
                    HistoricalMessageImpl message = (HistoricalMessageImpl)this.jcrom.fromNode(HistoricalMessageImpl.class, msgNode);
                    list.add(message);
                }
                conversationsNode.getSession().save();
                list.addAll(this.getHistoricalMessagesFromCache(usernameTo, usernameFrom, dateFrom, null));
                return list;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public List<HistoricalMessage> getHistoricalMessages(String usernameTo, String usernameFrom, Boolean isGroupChat, Date dateFrom, Date dateTo, SessionProvider sessionProvider) {
        ArrayList<HistoricalMessage> list = new ArrayList<HistoricalMessage>();
        try {
            Node conversationsNode = this.getConversationsNode(sessionProvider);
            Node participantsNode = this.getParticipantsNode(sessionProvider);
            Conversation conversation = this.getConversation(conversationsNode, participantsNode, usernameTo, usernameFrom, isGroupChat, false);
            if (conversation != null) {
                Node node = conversationsNode.getNode(conversation.getConversationId());
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(dateFrom);
                String dateFromStr = ISO8601.format((Calendar)calendar);
                calendar.setTime(dateTo);
                String dateToStr = ISO8601.format((Calendar)calendar);
                String sql = "SELECT * FROM " + HISTORICAL_MESSAGE_NT + " WHERE jcr:path LIKE '" + node.getPath() + "/%' " + " AND " + LR_MESSAGE_DATESEND + " BETWEEN TIMESTAMP '" + dateFromStr + "' AND TIMESTAMP '" + dateToStr + "'";
                QueryManager queryManager = node.getSession().getWorkspace().getQueryManager();
                Query query = queryManager.createQuery(sql, "sql");
                QueryResult queryResult = query.execute();
                NodeIterator nodeIterator = queryResult.getNodes();
                while (nodeIterator.hasNext()) {
                    Node msgNode = (Node)nodeIterator.next();
                    list.add((HistoricalMessage)this.jcrom.fromNode(HistoricalMessageImpl.class, msgNode));
                }
                list.addAll(this.getHistoricalMessagesFromCache(usernameTo, usernameFrom, dateFrom, dateTo));
                return list;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public List<Interlocutor> getInterlocutors(String participantName, SessionProvider sessionProvider) {
        ArrayList<Interlocutor> list = new ArrayList<Interlocutor>();
        try {
            Node participantsNode = this.getParticipantsNode(sessionProvider);
            Participant participant = this.getParticipant(participantsNode, CodingUtils.encodeToHex(participantName));
            if (participant != null) {
                if (participant.getInterlocutorList() != null) {
                    list.addAll(participant.getInterlocutorList());
                }
                if (participant.getGroupChatList() != null) {
                    list.addAll(participant.getGroupChatList());
                }
                return list;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public void messageReceive(String messageId, SessionProvider sessionProvider) {
        try {
            Node node = this.getConversationsNode(sessionProvider);
            String sql = "SELECT * FROM " + HISTORICAL_MESSAGE_NT + " WHERE jcr:path LIKE '" + node.getPath() + "/%/" + messageId + "'";
            QueryManager queryManager = node.getSession().getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(sql, "sql");
            QueryResult queryResult = query.execute();
            NodeIterator nodeIterator = queryResult.getNodes();
            while (nodeIterator.hasNext()) {
                Node nodeMsg = (Node)nodeIterator.next();
                HistoricalMessageImpl msg = (HistoricalMessageImpl)this.jcrom.fromNode(HistoricalMessageImpl.class, nodeMsg);
                msg.setReceive(true);
                this.jcrom.updateNode(nodeMsg, (Object)msg);
            }
            node.getSession().save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<HistoricalMessage> getNotReciveMessage(String usernameTo, SessionProvider sessionProvider) {
        ArrayList<HistoricalMessage> list = new ArrayList<HistoricalMessage>();
        try {
            Node node = this.getConversationsNode(sessionProvider);
            String sql = "SELECT * FROM " + HISTORICAL_MESSAGE_NT + " WHERE jcr:path LIKE '" + node.getPath() + "/%' " + " AND " + LR_MESSAGE_TO + " LIKE '" + usernameTo + "%' AND " + LR_MESSAGE_RECIEVE + " = 'false'";
            QueryManager queryManager = node.getSession().getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(sql, "sql");
            QueryResult queryResult = query.execute();
            NodeIterator nodeIterator = queryResult.getNodes();
            while (nodeIterator.hasNext()) {
                Node nodeMsg = (Node)nodeIterator.next();
                HistoricalMessageImpl msg = (HistoricalMessageImpl)this.jcrom.fromNode(HistoricalMessageImpl.class, nodeMsg);
                list.add(msg);
            }
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return list;
        }
    }

    private List<HistoricalMessage> getHistoricalMessagesFromCache(String usernameTo, String usernameFrom, Date dateFrom, Date dateTo) {
        ArrayList<HistoricalMessage> list = new ArrayList<HistoricalMessage>();
        for (HistoricalMessage msg : this.logQueue) {
            if (msg.getTo() == null || msg.getFrom() == null) continue;
            String to = StringUtils.parseName((String)msg.getTo());
            String from = StringUtils.parseName((String)msg.getFrom());
            Date sendDate = msg.getDateSend();
            if ((!to.equals(usernameTo) || !from.equals(usernameFrom)) && (!from.equals(usernameTo) || !to.equals(usernameFrom)) || !(dateFrom == null && dateTo == null || dateFrom != null && dateTo == null && sendDate.after(dateFrom)) && (dateFrom == null || dateTo == null || !sendDate.after(dateFrom) || !sendDate.before(dateTo))) continue;
            list.add(msg);
        }
        return list;
    }

    private Participant getParticipant(Node participantsNode, String hexName) {
        try {
            if (participantsNode.hasNode(hexName)) {
                Node node = participantsNode.getNode(hexName);
                Participant participant = (Participant)this.jcrom.fromNode(Participant.class, node);
                return participant;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void updateParticipant(Node participantsNode, Participant participant) {
        try {
            String hexName = CodingUtils.encodeToHex(participant.getUsername());
            if (participantsNode.hasNode(hexName)) {
                Node node = participantsNode.getNode(hexName);
                this.jcrom.updateNode(node, (Object)participant);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Conversation getConversation(Node convesationNode, Node participantsNode, String usernameTo, String usernameFrom, Boolean isRoom, Boolean withMessages) {
        try {
            InterlocutorImpl interlocutor;
            Participant participant = this.getParticipant(participantsNode, CodingUtils.encodeToHex(usernameTo));
            String conversationId = null;
            if (participant != null && (interlocutor = isRoom == false ? participant.getInterlocutor(usernameFrom) : participant.getGroupChat(usernameFrom)) != null && convesationNode.hasNode(conversationId = interlocutor.getConversationId())) {
                Node node = convesationNode.getNode(conversationId);
                Conversation conversation = new Conversation();
                conversation = withMessages != false ? (Conversation)this.jcrom.fromNode(Conversation.class, node) : (Conversation)this.jcrom.fromNode(Conversation.class, node, "-messageList", -1);
                return conversation;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private Conversation createNewConversation(Node conversationsNode, Node participantsNode, String conversationId, Date date, HistoricalMessageImpl message) {
        ArrayList<InterlocutorImpl> list;
        String jidTo = message.getTo();
        String jidFrom = message.getFrom();
        Boolean isGroupChat = message.getType().equals(Message.Type.groupchat.name());
        Participant participantTo = this.getParticipant(participantsNode, CodingUtils.encodeToHex(StringUtils.parseName((String)jidTo)));
        InterlocutorImpl interlocutorFrom = new InterlocutorImpl(jidFrom, conversationId, isGroupChat);
        if (!isGroupChat.booleanValue()) {
            if (participantTo != null) {
                if (participantTo.getInterlocutorList() != null) {
                    participantTo.addInterlocutor(interlocutorFrom);
                } else {
                    list = new ArrayList();
                    list.add(interlocutorFrom);
                    participantTo.setInterlocutorList(list);
                }
                this.updateParticipant(participantsNode, participantTo);
            } else {
                list = new ArrayList<InterlocutorImpl>();
                list.add(interlocutorFrom);
                participantTo = new Participant(jidTo, list, new ArrayList<InterlocutorImpl>());
                this.addParticipant(participantsNode, participantTo);
            }
            Participant participantFrom = this.getParticipant(participantsNode, CodingUtils.encodeToHex(StringUtils.parseName((String)jidFrom)));
            InterlocutorImpl interlocutorTo = new InterlocutorImpl(jidTo, conversationId, isGroupChat);
            if (participantFrom != null) {
                if (participantFrom.getInterlocutorList() != null) {
                    participantFrom.addInterlocutor(interlocutorTo);
                } else {
                    ArrayList<InterlocutorImpl> list2 = new ArrayList<InterlocutorImpl>();
                    list2.add(interlocutorTo);
                    participantFrom.setInterlocutorList(list2);
                }
                this.updateParticipant(participantsNode, participantFrom);
            } else {
                ArrayList<InterlocutorImpl> list3 = new ArrayList<InterlocutorImpl>();
                list3.add(interlocutorTo);
                participantFrom = new Participant(jidFrom, list3, new ArrayList<InterlocutorImpl>());
                this.addParticipant(participantsNode, participantFrom);
            }
        } else if (participantTo != null) {
            if (participantTo.getGroupChatList() != null) {
                participantTo.addGroupChat(interlocutorFrom);
            } else {
                list = new ArrayList();
                list.add(interlocutorFrom);
                participantTo.setGroupChatList(list);
            }
            this.updateParticipant(participantsNode, participantTo);
        } else {
            list = new ArrayList();
            list.add(interlocutorFrom);
            participantTo = new Participant(jidTo, new ArrayList<InterlocutorImpl>(), list);
            this.addParticipant(participantsNode, participantTo);
        }
        Conversation conversation = new Conversation(conversationId, date, date);
        conversation.addMessage(message);
        this.addConversation(conversationsNode, conversation);
        return conversation;
    }

    private void addParticipant(Node participantsNode, Participant participant) {
        try {
            this.jcrom.addNode(participantsNode, (Object)participant);
            participantsNode.getSession().save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addConversation(Node conversationsNode, Conversation conversation) {
        try {
            this.jcrom.addNode(conversationsNode, (Object)conversation);
            conversationsNode.getSession().save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateConversation(Node conversationsNode, Conversation conversation, String username) throws Exception {
        if (conversationsNode.hasNode(conversation.getConversationId())) {
            Node node = conversationsNode.getNode(conversation.getConversationId());
            this.jcrom.updateNode(node, (Object)conversation);
            node.getSession().save();
        }
    }

    private Node getConversationsNode(SessionProvider sessionProvider) {
        try {
            ManageableRepository repository = this.repositoryService.getCurrentRepository();
            Session session = sessionProvider.getSession(this.wsName, repository);
            return session.getRootNode().getNode(this.historyPath + "/" + CONVERSATIONS);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Node getParticipantsNode(SessionProvider sessionProvider) {
        try {
            ManageableRepository repository = this.repositoryService.getCurrentRepository();
            Session session = sessionProvider.getSession(this.wsName, repository);
            return session.getRootNode().getNode(this.historyPath + "/" + PARTICIPANTS);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void savePresenceStatus(SessionProvider provider, String userId, String status) throws Exception {
        Node dpsNode = this.getDefaultPresenceStatusNode(provider);
        String hexName = CodingUtils.encodeToHex(userId);
        PresenceStatus presenceStatus = this.getPresenceStatus(dpsNode, hexName);
        if (dpsNode == null) {
            try {
                ManageableRepository repository = this.repositoryService.getCurrentRepository();
                Session session = provider.getSession(this.wsName, repository);
                Node node = session.getRootNode();
                Node fNode = null;
                Node historyNode = node.getNode(this.historyPath);
                String[] path = this.historyPath.split("/");
                if (historyNode == null) {
                    for (int i = 0; i < path.length - 1; ++i) {
                        Node tmpNode = node.hasNode(path[i]) ? node.getNode(path[i]) : node.addNode(path[i]);
                        node = tmpNode;
                    }
                    fNode = node.addNode(path[path.length - 1], HISTORY_NT);
                } else {
                    fNode = historyNode.getNode(path[path.length - 1]);
                }
                NodeImpl dps = (NodeImpl)fNode.addNode(DEFAULTPRESENCESTATUS, DEFAULTPRESENCESTATUS_NT);
                if (dps.canAddMixin("exo:privilegeable")) {
                    dps.addMixin("exo:privilegeable");
                }
                dps.setPermission(SystemIdentity.ANY, PermissionType.ALL);
                presenceStatus = new PresenceStatus(userId, status);
                this.addPresenceStatus((Node)dps, presenceStatus);
                session.save();
            }
            catch (Exception e) {
                this.log.error((Object)("Could not add a new node for [lr:defaultpresecestatus] node type: " + e.getMessage()));
            }
        } else if (presenceStatus == null) {
            presenceStatus = new PresenceStatus(userId, status);
            this.addPresenceStatus(dpsNode, presenceStatus);
            dpsNode.getSession().save();
        } else if (presenceStatus.getHexName().equals(hexName)) {
            Node presenceStatusNode = null;
            presenceStatus.setStatus(status);
            try {
                if (dpsNode.hasNode(presenceStatus.getHexName())) {
                    presenceStatusNode = dpsNode.getNode(presenceStatus.getHexName());
                    this.jcrom.updateNode(presenceStatusNode, (Object)presenceStatus);
                    dpsNode.getSession().save();
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Could not update [lr:presencestatus] node: " + e.getMessage()));
            }
        }
    }

    public String getPresenceStatusHistory(SessionProvider provider, String userId) {
        String hexName;
        Node dpsNode = this.getDefaultPresenceStatusNode(provider);
        PresenceStatus ps = this.getPresenceStatus(dpsNode, hexName = CodingUtils.encodeToHex(userId));
        if (ps != null) {
            return ps.getStatus();
        }
        return null;
    }

    private void addPresenceStatus(Node dpsNode, PresenceStatus presenceStatus) {
        try {
            this.jcrom.addNode(dpsNode, (Object)presenceStatus);
        }
        catch (Exception e) {
            this.log.error((Object)("Could not add new a node to [lr:presencestatus] node type: " + e.getMessage()));
        }
    }

    public PresenceStatus getPresenceStatus(Node dpsNode, String hexName) {
        PresenceStatus presenceStatus = null;
        try {
            if (dpsNode.hasNode(hexName)) {
                Node presenceStatusNode = dpsNode.getNode(hexName);
                presenceStatus = (PresenceStatus)this.jcrom.fromNode(PresenceStatus.class, presenceStatusNode);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Getting a PresenceStatus fail: " + e.getMessage()), e.getCause());
        }
        return presenceStatus;
    }

    private Node getDefaultPresenceStatusNode(SessionProvider sessionProvider) {
        Node defaultPresenceStatusNode = null;
        try {
            ManageableRepository repository = this.repositoryService.getCurrentRepository();
            Session session = sessionProvider.getSession(this.wsName, repository);
            Node root = session.getRootNode();
            defaultPresenceStatusNode = root.getNode(this.historyPath + "/" + DEFAULTPRESENCESTATUS);
        }
        catch (Exception e) {
            this.log.error((Object)("Default Presence status node is not exist:  " + e.getMessage()));
        }
        return defaultPresenceStatusNode;
    }
}

