/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.query;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import org.chromattic.api.ChromatticException;
import org.chromattic.api.UndeclaredRepositoryException;
import org.chromattic.api.query.QueryBuilder;
import org.chromattic.api.query.QueryLanguage;
import org.chromattic.core.DomainSession;
import org.chromattic.core.query.QueryBuilderImpl;
import org.chromattic.core.query.QueryImpl;
import org.chromattic.core.query.QueryKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryManager {
    private static EnumMap<QueryLanguage, String> languages = new EnumMap(QueryLanguage.class);
    private EnumMap<QueryLanguage, Map<QueryKey, org.chromattic.api.query.Query<?>>> globalQueryCache;
    private final String rootNodePath;

    public QueryManager(String rootNodePath) {
        this.rootNodePath = rootNodePath;
    }

    public <O> QueryBuilder<O> createQueryBuilder(DomainSession session, Class<O> fromClass) throws ChromatticException {
        return new QueryBuilderImpl<O>(session, fromClass, this.rootNodePath);
    }

    public <O> org.chromattic.api.query.Query<O> getObjectQuery(DomainSession session, Class<O> objectClass, String statement) {
        try {
            Map<QueryKey, org.chromattic.api.query.Query<?>> queryCache;
            QueryLanguage language = QueryLanguage.SQL;
            QueryKey key = new QueryKey(objectClass, statement);
            org.chromattic.api.query.Query<?> query = null;
            if (this.globalQueryCache != null && (queryCache = this.globalQueryCache.get(language)) != null) {
                query = queryCache.get(key);
            }
            if (query == null) {
                Map<QueryKey, org.chromattic.api.query.Query<?>> queryCache2;
                Session jcrSession = session.getJCRSession();
                javax.jcr.query.QueryManager queryMgr = jcrSession.getWorkspace().getQueryManager();
                Query jcrQuery = queryMgr.createQuery(statement, "sql");
                query = new QueryImpl(session, objectClass, jcrQuery);
                if (this.globalQueryCache == null) {
                    this.globalQueryCache = new EnumMap(QueryLanguage.class);
                    queryCache2 = new HashMap();
                    this.globalQueryCache.put(language, queryCache2);
                } else {
                    queryCache2 = this.globalQueryCache.get(language);
                    if (queryCache2 == null) {
                        this.globalQueryCache.put(language, queryCache2);
                    }
                }
                queryCache2.put(key, query);
            }
            org.chromattic.api.query.Query<?> ret = query;
            return ret;
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    static {
        languages.put(QueryLanguage.SQL, "sql");
        languages.put(QueryLanguage.XPATH, "xpath");
    }
}

