/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.mvcc;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.AbstractNodeFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.InternalNode;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.UnversionedNode;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.mvcc.NodeReference;
import org.jboss.cache.mvcc.NullMarkerNode;
import org.jboss.cache.mvcc.NullMarkerNodeForRemoval;
import org.jboss.cache.mvcc.ReadCommittedNode;
import org.jboss.cache.mvcc.RepeatableReadNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MVCCNodeFactory<K, V>
extends AbstractNodeFactory<K, V> {
    private boolean useRepeatableRead;
    private static final Log log = LogFactory.getLog(MVCCNodeFactory.class);
    private static final boolean trace = log.isTraceEnabled();
    private boolean lockChildForInsertRemove;

    @Start
    public void init() {
        this.useRepeatableRead = this.configuration.getIsolationLevel() == IsolationLevel.REPEATABLE_READ;
        this.lockChildForInsertRemove = this.configuration.isLockParentForChildInsertRemove();
    }

    @Override
    public ReadCommittedNode createWrappedNode(InternalNode<K, V> node, InternalNode<K, V> parent) {
        return this.createWrappedNode(null, node, parent, false);
    }

    @Override
    public ReadCommittedNode createWrappedNodeForRemoval(Fqn fqn, InternalNode<K, V> node, InternalNode<K, V> parent) {
        return this.createWrappedNode(fqn, node, parent, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ReadCommittedNode createWrappedNode(Fqn fqn, InternalNode<K, V> node, InternalNode<K, V> parent, boolean forRemoval) {
        ReadCommittedNode rcn;
        if (node == null) {
            if (!this.useRepeatableRead) return null;
            if (!forRemoval) return NullMarkerNode.getInstance();
            rcn = new NullMarkerNodeForRemoval(parent, fqn);
        } else {
            rcn = this.useRepeatableRead ? new RepeatableReadNode(node, parent) : new ReadCommittedNode(node, parent);
        }
        rcn.initialize(this.configuration, this.invocationContextContainer, this.componentRegistry, this.interceptorChain);
        rcn.injectDependencies(this.cache);
        return rcn;
    }

    @Override
    public NodeSPI<K, V> createNode(Fqn fqn, NodeSPI<K, V> parent, Map<K, V> data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NodeSPI<K, V> createNode(Fqn fqn, NodeSPI<K, V> parent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NodeSPI<K, V> createRootNode() {
        return this.createWrappedNode(this.createInternalNode(Fqn.ROOT), null);
    }

    @Override
    public InternalNode<K, V> createInternalNode(Fqn fqn) {
        UnversionedNode un = new UnversionedNode(fqn, this.cache, this.lockChildForInsertRemove);
        if (!fqn.isRoot()) {
            un.setDataLoaded(false);
        }
        return this.useRepeatableRead ? un : new NodeReference(un);
    }

    @Override
    public NodeSPI<K, V> createNode(Object childName, NodeSPI<K, V> parent, Map<K, V> data) {
        return this.createNode(Fqn.fromRelativeElements(parent.getFqn(), childName), parent, data);
    }

    @Override
    public NodeSPI<K, V> createNode(Object childName, NodeSPI<K, V> parent) {
        return this.createNode(Fqn.fromRelativeElements(parent.getFqn(), childName), parent);
    }

    @Override
    public InternalNode<K, V> createChildNode(Fqn fqn, InternalNode<K, V> parent, InvocationContext ctx, boolean attachToParent) {
        if (fqn == null) {
            throw new IllegalArgumentException("null child fqn");
        }
        InternalNode<K, V> child = this.dataContainer.peekInternalNode(fqn, false);
        if (child == null) {
            this.cache.getNotifier().notifyNodeCreated(fqn, true, ctx);
            InternalNode<K, V> newChild = this.createInternalNode(fqn);
            if (attachToParent) {
                parent.addChild(newChild);
            }
            child = newChild;
            if (trace) {
                log.trace((Object)("Created new child with fqn [" + fqn + "]"));
            }
            this.cache.getNotifier().notifyNodeCreated(fqn, false, ctx);
        }
        return child;
    }
}

