/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.groovyscript;

import org.exoplatform.groovyscript.TextItem;

public class TemplateRuntimeException
extends Exception {
    private final String templateId;
    private final TextItem textItem;

    public TemplateRuntimeException(String templateId, TextItem textItem, String message, Throwable cause) {
        super(message, cause);
        this.templateId = templateId;
        this.textItem = textItem;
    }

    public TemplateRuntimeException(String templateId, TextItem textItem, Throwable cause) {
        super(cause);
        this.templateId = templateId;
        this.textItem = textItem;
    }

    public TextItem getTextItem() {
        return this.textItem;
    }

    public Integer getLineNumber() {
        return this.textItem != null ? Integer.valueOf(this.textItem.getPosition().getLine()) : null;
    }

    public String getText() {
        return this.textItem != null ? this.textItem.getData() : null;
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder("Groovy template exception");
        if (this.textItem != null) {
            sb.append(" at ").append(this.textItem);
        }
        if (this.templateId != null) {
            sb.append(" for template ").append(this.templateId);
        }
        return sb.toString();
    }
}

