/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.codec;

import java.io.UnsupportedEncodingException;
import org.jsecurity.codec.CodecException;

public abstract class CodecSupport {
    public static final String PREFERRED_ENCODING = "UTF-8";

    public static byte[] toBytes(char[] chars) {
        return CodecSupport.toBytes(new String(chars), PREFERRED_ENCODING);
    }

    public static byte[] toBytes(char[] chars, String encoding) throws CodecException {
        return CodecSupport.toBytes(new String(chars), encoding);
    }

    public static byte[] toBytes(String source) {
        return CodecSupport.toBytes(source, PREFERRED_ENCODING);
    }

    public static byte[] toBytes(String source, String encoding) throws CodecException {
        try {
            return source.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Unable to convert source [" + source + "] to byte array using " + "encoding '" + encoding + "'";
            throw new CodecException(msg, e);
        }
    }

    public static String toString(byte[] bytes) {
        return CodecSupport.toString(bytes, PREFERRED_ENCODING);
    }

    public static String toString(byte[] bytes, String encoding) throws CodecException {
        try {
            return new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Unable to convert byte array to String with encoding '" + encoding + "'.";
            throw new CodecException(msg, e);
        }
    }

    public static char[] toChars(byte[] bytes) {
        return CodecSupport.toChars(bytes, PREFERRED_ENCODING);
    }

    public static char[] toChars(byte[] bytes, String encoding) throws CodecException {
        return CodecSupport.toString(bytes, encoding).toCharArray();
    }

    protected byte[] toBytes(Object o) {
        if (o == null) {
            String msg = "Argument for byte conversion cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        if (o instanceof byte[]) {
            return (byte[])o;
        }
        if (o instanceof char[]) {
            return CodecSupport.toBytes((char[])o);
        }
        if (o instanceof String) {
            return CodecSupport.toBytes((String)o);
        }
        return this.objectToBytes(o);
    }

    protected String toString(Object o) {
        if (o == null) {
            String msg = "Argument for String conversion cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        if (o instanceof byte[]) {
            return CodecSupport.toString((byte[])o);
        }
        if (o instanceof char[]) {
            return new String((char[])o);
        }
        if (o instanceof String) {
            return (String)o;
        }
        return this.objectToString(o);
    }

    protected byte[] objectToBytes(Object o) {
        String msg = "The " + this.getClass().getName() + " implementation only supports conversion to " + "byte[] if the source is of type byte[], char[] or String.  The instance provided as a method " + "argument is of type [" + o.getClass().getName() + "].  If you would like to convert " + "this argument type to a byte[], you can 1) convert the argument to a byte[], char[] or String " + "yourself and then use that as the method argument or 2) subclass " + this.getClass().getName() + " and override the objectToBytes(Object o) method.";
        throw new CodecException(msg);
    }

    protected String objectToString(Object o) {
        return o.toString();
    }
}

