/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity.model;

import java.io.Serializable;

public class GlobalId
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SEPARATOR = ":";
    private String domain;
    private String localId;

    public GlobalId(String id) {
        if (!GlobalId.isValid(id)) {
            throw new IllegalArgumentException(id + " is not a valid GlobalId. " + "According to Opensocial specification, it should be of the form: " + "Global-Id   = Domain-Name \":\" Local-Id ");
        }
        String[] globalId = id.split(SEPARATOR);
        this.domain = globalId[0];
        this.localId = globalId[1];
    }

    public static boolean isValid(String id) {
        return id != null && id.indexOf(SEPARATOR) > 0;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getLocalId() {
        return this.localId;
    }

    public String toString() {
        return this.domain + SEPARATOR + this.localId;
    }

    public static GlobalId create(String providerId, String remoteId) {
        if (providerId == null) {
            throw new IllegalArgumentException("Could not create a valid GlobalId with null providerId");
        }
        if (remoteId == null) {
            throw new IllegalArgumentException("Could not create a valid GlobalId with null remoteId");
        }
        return new GlobalId(providerId + SEPARATOR + remoteId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + (this.localId == null ? 0 : this.localId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalId)) {
            return false;
        }
        GlobalId other = (GlobalId)obj;
        if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
            return false;
        }
        return !(this.localId == null ? other.localId != null : !this.localId.equals(other.localId));
    }
}

