/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.model.Activity;

public class OSHtmlSanitizerProcessor
extends BaseActivityProcessorPlugin {
    public static final String[] OS_ALLOWED_TAGS = new String[]{"b", "i", "a", "span"};
    private String[] allowedTags = OS_ALLOWED_TAGS;

    public OSHtmlSanitizerProcessor(InitParams params) {
        super(params);
        this.allowedTags = this.getAllowedTags(params, this.allowedTags);
    }

    private String[] getAllowedTags(InitParams initParams, String[] defaultValue) {
        String[] result = defaultValue;
        try {
            ValuesParam params = initParams.getValuesParam("allowedTags");
            ArrayList values = params.getValues();
            result = values.toArray(new String[values.size()]);
        }
        catch (Exception e) {
            return defaultValue;
        }
        return result;
    }

    public int getPriority() {
        return Integer.MIN_VALUE;
    }

    public void processActivity(Activity activity) {
        activity.setTitle(this.escapeHtml(activity.getTitle()));
        activity.setBody(this.escapeHtml(activity.getBody()));
    }

    String escapeHtml(String content) {
        if (content == null) {
            return null;
        }
        String result = content;
        String startTag = "<([^<]+)>|<([^<\\s]+)[\\s]+[^<]+>";
        String endTag = "</([^<]+)>";
        Pattern pattern = Pattern.compile(startTag + "|" + endTag);
        Matcher matcher = pattern.matcher(content);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            String tag;
            String replaceStr = matcher.group();
            if (replaceStr.startsWith("</")) {
                tag = replaceStr.trim().substring(2, replaceStr.length() - 1);
                if (!Arrays.asList(this.allowedTags).contains(tag)) {
                    replaceStr = "&lt;/" + tag + "&gt;";
                }
            } else {
                if (replaceStr.matches("<([^<\\s]+)[\\s]+[^<]+>")) {
                    String start = replaceStr.split("\\s")[0];
                    tag = start.substring(1);
                } else {
                    tag = replaceStr.trim().substring(1, replaceStr.length() - 1);
                }
                if (!Arrays.asList(this.allowedTags).contains(tag)) {
                    replaceStr = "&lt;" + replaceStr.substring(1, replaceStr.length() - 1) + "&gt;";
                }
            }
            matcher.appendReplacement(buf, replaceStr);
        }
        matcher.appendTail(buf);
        result = buf.toString();
        return result;
    }

    public String[] getAllowedTags() {
        return this.allowedTags;
    }

    public void setAllowedTags(String[] allowedTags) {
        this.allowedTags = allowedTags;
    }
}

