/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;

public class NIOFSDirectory
extends FSDirectory {
    static /* synthetic */ Class class$org$apache$lucene$store$NIOFSDirectory;

    public IndexInput openInput(String name, int bufferSize) throws IOException {
        this.ensureOpen();
        return new NIOFSIndexInput(new File(this.getFile(), name), bufferSize);
    }

    private static class NIOFSIndexInput
    extends FSDirectory.FSIndexInput {
        private ByteBuffer byteBuf;
        private byte[] otherBuffer;
        private ByteBuffer otherByteBuf;
        final FileChannel channel;
        static final /* synthetic */ boolean $assertionsDisabled;

        public NIOFSIndexInput(File path, int bufferSize) throws IOException {
            super(path, bufferSize);
            this.channel = this.file.getChannel();
        }

        protected void newBuffer(byte[] newBuffer) {
            super.newBuffer(newBuffer);
            this.byteBuf = ByteBuffer.wrap(newBuffer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (!this.isClone && this.file.isOpen) {
                try {
                    this.channel.close();
                }
                finally {
                    this.file.close();
                }
            }
        }

        protected void readInternal(byte[] b, int offset, int len) throws IOException {
            ByteBuffer bb;
            if (b == this.buffer && 0 == offset) {
                if (!$assertionsDisabled && this.byteBuf == null) {
                    throw new AssertionError();
                }
                this.byteBuf.clear();
                this.byteBuf.limit(len);
                bb = this.byteBuf;
            } else if (offset == 0) {
                if (this.otherBuffer != b) {
                    this.otherBuffer = b;
                    this.otherByteBuf = ByteBuffer.wrap(b);
                } else {
                    this.otherByteBuf.clear();
                }
                this.otherByteBuf.limit(len);
                bb = this.otherByteBuf;
            } else {
                bb = ByteBuffer.wrap(b, offset, len);
            }
            long pos = this.getFilePointer();
            while (bb.hasRemaining()) {
                int i = this.channel.read(bb, pos);
                if (i == -1) {
                    throw new IOException("read past EOF");
                }
                pos += (long)i;
            }
        }

        static {
            $assertionsDisabled = !(class$org$apache$lucene$store$NIOFSDirectory == null ? (class$org$apache$lucene$store$NIOFSDirectory = NIOFSDirectory.class$("org.apache.lucene.store.NIOFSDirectory")) : class$org$apache$lucene$store$NIOFSDirectory).desiredAssertionStatus();
        }
    }
}

