/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ecm.publication.REST.presentation.document.publication;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/publication/presentation/")
public class PublicationGetDocumentRESTService
implements ResourceContainer {
    private RepositoryService repositoryService_;
    private PublicationService publicationService_;
    private ManageDriveService manageDriveService_;
    public static final String DEFAULT_ITEM = "5";
    private static final String LAST_MODIFIED_PROPERTY = "Last-Modified";
    private static final String IF_MODIFIED_SINCE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    private static final Log LOG = ExoLogger.getLogger(PublicationGetDocumentRESTService.class);

    public PublicationGetDocumentRESTService(RepositoryService repositoryService, PublicationService publicationService, ManageDriveService manageDriveService) {
        this.repositoryService_ = repositoryService;
        this.publicationService_ = publicationService;
        this.manageDriveService_ = manageDriveService;
    }

    @Path(value="/{repository}/{workspace}/{state}/")
    @GET
    public Response getPublishDocument(@PathParam(value="repository") String repoName, @PathParam(value="workspace") String wsName, @PathParam(value="state") String state, @QueryParam(value="showItems") String showItems) throws Exception {
        return this.getPublishDocument(repoName, wsName, state, null, showItems);
    }

    @Path(value="/{repository}/{workspace}/{publicationPluginName}/{state}/")
    @GET
    public Response getPublishedListDocument(@PathParam(value="repository") String repoName, @PathParam(value="workspace") String wsName, @PathParam(value="publicationPluginName") String pluginName, @PathParam(value="state") String state, @QueryParam(value="showItems") String showItems) throws Exception {
        return this.getPublishDocument(repoName, wsName, state, pluginName, showItems);
    }

    private Response getPublishDocument(String repoName, String wsName, String state, String pluginName, String itemPage) throws Exception {
        ArrayList<PublishedNode> publishedNodes = new ArrayList<PublishedNode>();
        PublishedListNode publishedListNode = new PublishedListNode();
        if (itemPage == null) {
            itemPage = DEFAULT_ITEM;
        }
        int item = Integer.parseInt(itemPage);
        String queryStatement = "select * from publication:publication order by exo:dateModified ASC";
        SessionProvider provider = SessionProviderFactory.createAnonimProvider();
        Session session = provider.getSession(wsName, this.repositoryService_.getRepository(repoName));
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        QueryImpl query = (QueryImpl)queryManager.createQuery(queryStatement, "sql");
        query.setLimit((long)item);
        query.setOffset(0L);
        QueryResult queryResult = query.execute();
        NodeIterator iter = queryResult.getNodes();
        List<Node> listNode = this.getNodePublish(iter, pluginName);
        Collections.sort(listNode, new DateComparator());
        if (listNode.size() < item) {
            item = listNode.size();
        }
        List lstDrive = this.manageDriveService_.getAllDrives(repoName);
        for (int i = 0; i < item; ++i) {
            PublishedNode publishedNode = new PublishedNode();
            Node node = listNode.get(i);
            publishedNode.setName(node.getName());
            publishedNode.setPath(node.getPath());
            publishedNode.setDatePublished(this.getPublishedDateTime(node));
            publishedNode.setDriveName(this.getDriveName(lstDrive, node));
            publishedNodes.add(publishedNode);
        }
        publishedListNode.setPublishedListNode(publishedNodes);
        session.logout();
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        return Response.ok((Object)publishedListNode, (MediaType)new MediaType("application", "json")).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }

    private List<Node> getNodePublish(NodeIterator iter, String pluginName) throws Exception {
        ArrayList<Node> listNode = new ArrayList<Node>();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            Node nodecheck = this.publicationService_.getNodePublish(node, pluginName);
            if (nodecheck == null) continue;
            listNode.add(node);
        }
        return listNode;
    }

    private String getPublishedDateTime(Node currentNode) throws Exception {
        Value[] history = currentNode.getProperty("publication:history").getValues();
        String time = currentNode.getProperty("exo:dateModified").getString();
        for (Value value : history) {
            String[] arrHistory = value.getString().split(";");
            time = arrHistory[3];
        }
        return String.valueOf(ISO8601.parse((String)time).getTimeInMillis());
    }

    private String getDriveName(List<DriveData> lstDrive, Node node) throws RepositoryException {
        String driveName = "";
        for (DriveData drive : lstDrive) {
            if (!node.getSession().getWorkspace().getName().equals(drive.getWorkspace()) || !node.getPath().contains(drive.getHomePath()) || !drive.getHomePath().equals("/")) continue;
            driveName = drive.getName();
            break;
        }
        return driveName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PublishedListNode {
        private List<PublishedNode> publishedListNode_;

        public void setPublishedListNode(List<PublishedNode> publishedListNode) {
            this.publishedListNode_ = publishedListNode;
        }

        public List<PublishedNode> getPublishedListNode() {
            return this.publishedListNode_;
        }
    }

    public class PublishedNode {
        private String nodeName_;
        private String nodePath_;
        private String driveName_;
        private String datePublished_;

        public void setName(String nodeName) {
            this.nodeName_ = nodeName;
        }

        public String getName() {
            return this.nodeName_;
        }

        public void setPath(String nodePath) {
            this.nodePath_ = nodePath;
        }

        public String getPath() {
            return this.nodePath_;
        }

        public void setDriveName(String driveName) {
            this.driveName_ = driveName;
        }

        public String getDriveName() {
            return this.driveName_;
        }

        public void setDatePublished(String datePublished) {
            this.datePublished_ = datePublished;
        }

        public String getDatePublished() {
            return this.datePublished_;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateComparator
    implements Comparator<Node> {
        private DateComparator() {
        }

        @Override
        public int compare(Node node1, Node node2) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd.HHmmss.SSS");
                Date date1 = formatter.parse(this.getDateTime(node1));
                Date date2 = formatter.parse(this.getDateTime(node2));
                return date2.compareTo(date1);
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
                return 0;
            }
        }

        private String getDateTime(Node currentNode) throws Exception {
            int i$ = 0;
            Value[] history = currentNode.getProperty("publication:history").getValues();
            Value[] arr$ = history;
            int len$ = arr$.length;
            if (i$ < len$) {
                Value value = arr$[i$];
                String[] arrHistory = value.getString().split(";");
                return arrHistory[3];
            }
            return currentNode.getProperty("exo:dateModified").getString();
        }
    }
}

