/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.NameTree;
import org.icepdf.core.pobjects.Outlines;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.core.pobjects.ViewerPreferences;
import org.icepdf.core.util.Library;

public class Catalog
extends Dictionary {
    private static final Logger logger = Logger.getLogger(Catalog.class.toString());
    private PageTree pageTree;
    private Outlines outlines;
    private NameTree nameTree;
    private Dictionary dests;
    private ViewerPreferences viewerPref;
    private boolean outlinesInited = false;
    private boolean namesTreeInited = false;
    private boolean destsInited = false;
    private boolean viewerPrefInited = false;

    public Catalog(Library l, Hashtable h) {
        super(l, h);
    }

    public synchronized void init() {
        Object tmp = this.library.getObject(this.entries, "Pages");
        this.pageTree = null;
        if (tmp instanceof PageTree) {
            this.pageTree = (PageTree)tmp;
        } else if (tmp instanceof Hashtable) {
            this.pageTree = new PageTree(this.library, (Hashtable)tmp);
        }
        try {
            this.pageTree.init();
            this.pageTree.initRootPageTree();
        }
        catch (NullPointerException e) {
            logger.log(Level.FINE, "Error parsing page tree.", e);
        }
    }

    public void dispose(boolean cache) {
        if (this.nameTree != null) {
            this.nameTree.dispose();
            this.namesTreeInited = false;
            if (!cache) {
                this.nameTree = null;
            }
        }
        if (this.pageTree != null) {
            this.pageTree.dispose(cache);
            if (!cache) {
                this.pageTree = null;
            }
        }
        if (this.outlines != null && !cache) {
            this.outlines.dispose();
            this.outlines = null;
        }
    }

    public PageTree getPageTree() {
        return this.pageTree;
    }

    public Outlines getOutlines() {
        if (!this.outlinesInited) {
            this.outlinesInited = true;
            Object o = this.library.getObject(this.entries, "Outlines");
            if (o != null) {
                this.outlines = new Outlines(this.library, (Hashtable)o);
            }
        }
        return this.outlines;
    }

    public NameTree getNameTree() {
        if (!this.namesTreeInited) {
            Hashtable dest;
            Object names;
            this.namesTreeInited = true;
            Object o = this.library.getObject(this.entries, "Names");
            if (o != null && o instanceof Hashtable && (names = this.library.getObject(dest = (Hashtable)o, "Dests")) != null && names instanceof Hashtable) {
                this.nameTree = new NameTree(this.library, (Hashtable)names);
                this.nameTree.init();
            }
        }
        return this.nameTree;
    }

    public Dictionary getDestinations() {
        if (!this.destsInited) {
            this.destsInited = true;
            Object o = this.library.getObject(this.entries, "Dests");
            if (o != null) {
                this.dests = new Dictionary(this.library, (Hashtable)o);
                this.dests.init();
            }
        }
        return this.dests;
    }

    public ViewerPreferences getViewerPreferences() {
        if (!this.viewerPrefInited) {
            this.viewerPrefInited = true;
            Object o = this.library.getObject(this.entries, "ViewerPreferences");
            if (o != null) {
                this.viewerPref = new ViewerPreferences(this.library, (Hashtable)o);
                this.viewerPref.init();
            }
        }
        return this.viewerPref;
    }

    public String toString() {
        return "CATALOG= " + this.entries.toString();
    }

    static {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("ICEsoft ICEpdf Core " + Document.getLibraryVersion());
        }
    }
}

