/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.util.Hashtable;
import java.util.Vector;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.util.Library;

public class NameNode
extends Dictionary {
    private static Object NOT_FOUND = new Object();
    private static Object NOT_FOUND_IS_LESSER = new Object();
    private static Object NOT_FOUND_IS_GREATER = new Object();
    private boolean namesAreDecrypted;
    private Vector namesAndValues;
    private Vector kidsReferences;
    private Vector kidsNodes;
    private String lowerLimit;
    private String upperLimit;

    public NameNode(Library l, Hashtable h) {
        super(l, h);
        Vector limits;
        Object o = this.library.getObject(this.entries, "Kids");
        if (o != null && o instanceof Vector) {
            Vector v;
            this.kidsReferences = v = (Vector)o;
            int sz = this.kidsReferences.size();
            if (sz > 0) {
                this.kidsNodes = new Vector(sz);
                this.kidsNodes.setSize(sz);
            }
        }
        this.namesAreDecrypted = false;
        o = this.library.getObject(this.entries, "Names");
        if (o != null && o instanceof Vector) {
            this.namesAndValues = (Vector)o;
        }
        if ((o = this.library.getObject(this.entries, "Limits")) != null && o instanceof Vector && (limits = (Vector)o).size() >= 2) {
            this.lowerLimit = this.decryptIfText(limits.get(0));
            this.upperLimit = this.decryptIfText(limits.get(1));
        }
    }

    public boolean isEmpty() {
        return this.kidsNodes.size() == 0;
    }

    public boolean hasLimits() {
        return this.library.getObject(this.entries, "Limits") != null;
    }

    public Vector getNamesAndValues() {
        return this.namesAndValues;
    }

    public Vector getKidsReferences() {
        return this.kidsReferences;
    }

    public Vector getKidsNodes() {
        return this.kidsNodes;
    }

    public String getLowerLimit() {
        return this.lowerLimit;
    }

    public String getUpperLimit() {
        return this.upperLimit;
    }

    private void ensureNamesDecrypted() {
        if (this.namesAreDecrypted) {
            return;
        }
        this.namesAreDecrypted = true;
        for (int i = 0; i < this.namesAndValues.size(); i += 2) {
            this.namesAndValues.set(i, this.decryptIfText(this.namesAndValues.get(i)));
        }
    }

    private String decryptIfText(Object tmp) {
        if (tmp instanceof StringObject) {
            StringObject nameText = (StringObject)tmp;
            return nameText.getDecryptedLiteralString(this.library.securityManager);
        }
        if (tmp instanceof String) {
            return (String)tmp;
        }
        return null;
    }

    Object searchName(String name) {
        Object ret = this.search(name);
        if (ret == NOT_FOUND || ret == NOT_FOUND_IS_LESSER || ret == NOT_FOUND_IS_GREATER) {
            ret = null;
        }
        return ret;
    }

    private Object search(String name) {
        if (this.kidsReferences != null) {
            int cmp;
            if (this.lowerLimit != null) {
                cmp = this.lowerLimit.toString().compareTo(name);
                if (cmp > 0) {
                    return NOT_FOUND_IS_LESSER;
                }
                if (cmp == 0) {
                    return this.getNode(0).search(name);
                }
            }
            if (this.upperLimit != null) {
                cmp = this.upperLimit.toString().compareTo(name);
                if (cmp < 0) {
                    return NOT_FOUND_IS_GREATER;
                }
                if (cmp == 0) {
                    return this.getNode(this.kidsReferences.size() - 1).search(name);
                }
            }
            return this.binarySearchKids(0, this.kidsReferences.size() - 1, name);
        }
        if (this.namesAndValues != null) {
            int cmp;
            int numNamesAndValues = this.namesAndValues.size();
            if (this.lowerLimit != null) {
                cmp = this.lowerLimit.toString().compareTo(name);
                if (cmp > 0) {
                    return NOT_FOUND_IS_LESSER;
                }
                if (cmp == 0) {
                    this.ensureNamesDecrypted();
                    if (this.namesAndValues.get(0).toString().equals(name)) {
                        Object ob = this.namesAndValues.get(1);
                        if (ob instanceof Reference) {
                            ob = this.library.getObject((Reference)ob);
                        }
                        return ob;
                    }
                }
            }
            if (this.upperLimit != null) {
                cmp = this.upperLimit.toString().compareTo(name);
                if (cmp < 0) {
                    return NOT_FOUND_IS_GREATER;
                }
                if (cmp == 0) {
                    this.ensureNamesDecrypted();
                    if (this.namesAndValues.get(numNamesAndValues - 2).toString().equals(name)) {
                        Object ob = this.namesAndValues.get(numNamesAndValues - 1);
                        if (ob instanceof Reference) {
                            ob = this.library.getObject((Reference)ob);
                        }
                        return ob;
                    }
                }
            }
            this.ensureNamesDecrypted();
            Object ret = this.binarySearchNames(0, numNamesAndValues - 1, name);
            if (ret == NOT_FOUND || ret == NOT_FOUND_IS_LESSER || ret == NOT_FOUND_IS_GREATER) {
                ret = null;
            }
            return ret;
        }
        return null;
    }

    private Object binarySearchKids(int firstIndex, int lastIndex, String name) {
        if (firstIndex > lastIndex) {
            return NOT_FOUND;
        }
        int pivot = firstIndex + (lastIndex - firstIndex) / 2;
        Object ret = this.getNode(pivot).search(name);
        if (ret == NOT_FOUND_IS_LESSER) {
            return this.binarySearchKids(firstIndex, pivot - 1, name);
        }
        if (ret == NOT_FOUND_IS_GREATER) {
            return this.binarySearchKids(pivot + 1, lastIndex, name);
        }
        if (ret == NOT_FOUND) {
            for (int i = firstIndex; i <= lastIndex; ++i) {
                Object r;
                if (i == pivot || (r = this.getNode(i).search(name)) == NOT_FOUND || r == NOT_FOUND_IS_LESSER || r == NOT_FOUND_IS_GREATER) continue;
                ret = r;
                break;
            }
        }
        return ret;
    }

    private Object binarySearchNames(int firstIndex, int lastIndex, String name) {
        if (firstIndex > lastIndex) {
            return NOT_FOUND;
        }
        int pivot = firstIndex + (lastIndex - firstIndex) / 2;
        int cmp = this.namesAndValues.get(pivot &= 0xFFFFFFFE).toString().compareTo(name);
        if (cmp == 0) {
            Object ob = this.namesAndValues.get(pivot + 1);
            if (ob instanceof Reference) {
                ob = this.library.getObject((Reference)ob);
            }
            return ob;
        }
        if (cmp > 0) {
            return this.binarySearchNames(firstIndex, pivot - 1, name);
        }
        if (cmp < 0) {
            return this.binarySearchNames(pivot + 2, lastIndex, name);
        }
        return NOT_FOUND;
    }

    public NameNode getNode(int index) {
        NameNode n = (NameNode)this.kidsNodes.get(index);
        if (n == null) {
            Reference r = (Reference)this.kidsReferences.get(index);
            Hashtable nh = (Hashtable)this.library.getObject(r);
            n = new NameNode(this.library, nh);
            this.kidsNodes.set(index, n);
        }
        return n;
    }

    public void dispose() {
        if (this.namesAndValues != null) {
            this.namesAndValues.clear();
            this.namesAndValues.trimToSize();
        }
        if (this.kidsReferences != null) {
            this.kidsReferences.clear();
            this.kidsReferences.trimToSize();
        }
        if (this.kidsNodes != null) {
            this.kidsNodes.clear();
            this.kidsNodes.trimToSize();
        }
    }
}

