/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.util.Hashtable;
import java.util.Vector;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.util.Library;

public class Indexed
extends PColorSpace {
    PColorSpace colorSpace;
    int hival;
    byte[] colors = new byte[]{-1, -1, -1, 0, 0, 0};
    private boolean inited = false;
    private Color[] cols;

    Indexed(Library library, Hashtable entries, Vector dictionary) {
        super(library, entries);
        this.colorSpace = Indexed.getColorSpace(library, dictionary.elementAt(1));
        this.hival = ((Number)dictionary.elementAt(2)).intValue();
        if (dictionary.elementAt(3) instanceof StringObject) {
            StringObject tmpText = (StringObject)dictionary.elementAt(3);
            String tmp = tmpText.getDecryptedLiteralString(library.securityManager);
            byte[] textBytes = new byte[this.colorSpace.getNumComponents() * (this.hival + 1)];
            for (int i = 0; i < textBytes.length; ++i) {
                textBytes[i] = (byte)tmp.charAt(i);
            }
            this.colors = textBytes;
        } else if (dictionary.elementAt(3) instanceof Reference) {
            Stream lookup = (Stream)library.getObject((Reference)dictionary.elementAt(3));
            this.colors = lookup.getBytes();
        }
    }

    public int getNumComponents() {
        return 1;
    }

    public String getDescription() {
        String desc = super.getDescription();
        if (this.colorSpace != null) {
            desc = desc + ":" + this.colorSpace.getDescription();
        }
        return desc;
    }

    public void init() {
        if (this.inited) {
            return;
        }
        this.inited = true;
        int numCSComps = this.colorSpace.getNumComponents();
        int[] b1 = new int[numCSComps];
        float[] f1 = new float[numCSComps];
        this.cols = new Color[this.hival + 1];
        for (int j = 0; j <= this.hival; ++j) {
            for (int i = 0; i < numCSComps; ++i) {
                b1[numCSComps - 1 - i] = 0xFF & this.colors[j * numCSComps + i];
            }
            this.colorSpace.normaliseComponentsToFloats(b1, f1, 255.0f);
            this.cols[j] = this.colorSpace.getColor(f1);
        }
    }

    public Color getColor(float[] f) {
        this.init();
        int index = (int)(f[0] * (float)(this.cols.length - 1));
        return this.cols[index];
    }

    public Color[] accessColorTable() {
        return this.cols;
    }
}

