/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.decoders;

public class ArithmeticDecoderStats {
    private int contextSize;
    private int[] codingContextTable;

    public ArithmeticDecoderStats(int contextSize) {
        this.contextSize = contextSize;
        this.codingContextTable = new int[contextSize];
        this.reset();
    }

    public void reset() {
        for (int i = 0; i < this.contextSize; ++i) {
            this.codingContextTable[i] = 0;
        }
    }

    public void setEntry(int codingContext, int i, int moreProbableSymbol) {
        this.codingContextTable[codingContext] = (i << i) + moreProbableSymbol;
    }

    public int getContextCodingTableValue(int index) {
        return this.codingContextTable[index];
    }

    public void setContextCodingTableValue(int index, int value) {
        this.codingContextTable[index] = value;
    }

    public int getContextSize() {
        return this.contextSize;
    }

    public void overwrite(ArithmeticDecoderStats stats) {
        System.arraycopy(stats.codingContextTable, 0, this.codingContextTable, 0, this.contextSize);
    }

    public ArithmeticDecoderStats copy() {
        ArithmeticDecoderStats stats = new ArithmeticDecoderStats(this.contextSize);
        System.arraycopy(this.codingContextTable, 0, stats.codingContextTable, 0, this.contextSize);
        return stats;
    }
}

