/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype.registration;

import java.util.LinkedList;
import java.util.List;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataImpl;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionData;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.Constants;

public class NodeTypeDataBuilder {
    private InternalQName name;
    private InternalQName[] supertypes = new InternalQName[]{Constants.NT_BASE};
    private boolean isMixin = false;
    private boolean isOrderable = false;
    private InternalQName primaryItemName = null;
    private PropertyDefinitionData[] propertyDefinitions = new PropertyDefinitionData[0];
    private NodeDefinitionData[] childNodeDefinitions = new NodeDefinitionData[0];
    private boolean isAbstract = false;
    private boolean isQueryable = true;
    private List<NodeDefinitionDataBuilder> nodeDefinitionDataBuilders = new LinkedList<NodeDefinitionDataBuilder>();
    private List<PropertyDefinitionDataBuilder> propertyDefinitionDataBuilders = new LinkedList<PropertyDefinitionDataBuilder>();

    public NodeDefinitionDataBuilder newNodeDefinitionDataBuilder() {
        NodeDefinitionDataBuilder child = new NodeDefinitionDataBuilder(this.name);
        this.nodeDefinitionDataBuilders.add(child);
        return child;
    }

    public PropertyDefinitionDataBuilder newPropertyDefinitionDataBuilder() {
        PropertyDefinitionDataBuilder property = new PropertyDefinitionDataBuilder(this.name);
        this.propertyDefinitionDataBuilders.add(property);
        return property;
    }

    public boolean removeNodeDefinitionDataBuilder(NodeDefinitionDataBuilder childBuilder) {
        return this.nodeDefinitionDataBuilders.remove(childBuilder);
    }

    public boolean removePropertyDefinitionDataBuilder(PropertyDefinitionDataBuilder propertyBuilder) {
        return this.propertyDefinitionDataBuilders.remove(propertyBuilder);
    }

    public NodeTypeData build() {
        int i;
        if (this.nodeDefinitionDataBuilders.size() > 0) {
            this.childNodeDefinitions = new NodeDefinitionData[this.nodeDefinitionDataBuilders.size()];
            for (i = 0; i < this.childNodeDefinitions.length; ++i) {
                this.childNodeDefinitions[i] = this.nodeDefinitionDataBuilders.get(i).build();
            }
        }
        if (this.propertyDefinitionDataBuilders.size() > 0) {
            this.propertyDefinitions = new PropertyDefinitionData[this.propertyDefinitionDataBuilders.size()];
            for (i = 0; i < this.propertyDefinitions.length; ++i) {
                this.propertyDefinitions[i] = this.propertyDefinitionDataBuilders.get(i).build();
            }
        }
        return new NodeTypeDataImpl(this.name, this.primaryItemName, this.isMixin, this.isOrderable, this.supertypes, this.propertyDefinitions, this.childNodeDefinitions);
    }

    public void setName(InternalQName name) {
        this.name = name;
    }

    public void setSupertypes(InternalQName[] supertypes) {
        this.supertypes = supertypes;
    }

    public void setMixin(boolean isMixin) {
        this.isMixin = isMixin;
    }

    public void setOrderable(boolean isOrderable) {
        this.isOrderable = isOrderable;
    }

    public void setPrimaryItemName(InternalQName primaryItemName) {
        this.primaryItemName = primaryItemName;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public void setQueryable(boolean isQueryable) {
        this.isQueryable = isQueryable;
    }

    public class PropertyDefinitionDataBuilder {
        private InternalQName name;
        private int requiredType = 1;
        private String[] valueConstraints = null;
        private String[] defaultValues = null;
        private boolean isAutoCreated = false;
        private boolean isProtected = false;
        private boolean isMandatory = false;
        private boolean isMultiple = false;
        private boolean isFullTextSearchable;
        private boolean isQueryOrderable;
        private String[] queryOperators;
        private int onParentVersion = 1;
        private InternalQName declaringType;

        private PropertyDefinitionDataBuilder(InternalQName declaringType) {
            this.declaringType = declaringType;
        }

        private PropertyDefinitionData build() {
            return new PropertyDefinitionData(this.name, this.declaringType, this.isAutoCreated, this.isMandatory, this.onParentVersion, this.isProtected, this.requiredType, this.valueConstraints, this.defaultValues, this.isMultiple);
        }

        public void setName(InternalQName name) {
            this.name = name;
        }

        public void setRequiredType(int requiredType) {
            this.requiredType = requiredType;
        }

        public void setValueConstraints(String[] valueConstraints) {
            this.valueConstraints = valueConstraints;
        }

        public void setDefaultValues(String[] defaultValues) {
            this.defaultValues = defaultValues;
        }

        public void setAutoCreated(boolean isAutoCreated) {
            this.isAutoCreated = isAutoCreated;
        }

        public void setProtected(boolean isProtected) {
            this.isProtected = isProtected;
        }

        public void setMandatory(boolean isMandatory) {
            this.isMandatory = isMandatory;
        }

        public void setMultiple(boolean isMultiple) {
            this.isMultiple = isMultiple;
        }

        public void setFullTextSearchable(boolean fullTextSearchable) {
            this.isFullTextSearchable = fullTextSearchable;
        }

        public void setQueryOrderable(boolean isQueryOrderable) {
            this.isQueryOrderable = isQueryOrderable;
        }

        public void setQueryOperators(String[] queryOperators) {
            this.queryOperators = queryOperators;
        }

        public void setOnParentVersion(int onParentVersion) {
            this.onParentVersion = onParentVersion;
        }
    }

    public class NodeDefinitionDataBuilder {
        private InternalQName name;
        private InternalQName declaringType;
        private InternalQName defaultPrimaryType;
        private InternalQName[] requiredPrimaryTypes;
        private boolean isAutoCreated;
        private int onParentVersion;
        private boolean isProtected;
        private boolean isMandatory;
        private boolean allowsSameNameSiblings;

        private NodeDefinitionDataBuilder(InternalQName declaringType) {
            this.declaringType = declaringType;
            this.defaultPrimaryType = null;
            this.requiredPrimaryTypes = new InternalQName[]{Constants.NT_BASE};
            this.isAutoCreated = false;
            this.onParentVersion = 1;
            this.isProtected = false;
            this.isMandatory = false;
            this.allowsSameNameSiblings = false;
        }

        private NodeDefinitionData build() {
            return new NodeDefinitionData(this.name, this.declaringType, this.isAutoCreated, this.isMandatory, this.onParentVersion, this.isProtected, this.requiredPrimaryTypes, this.defaultPrimaryType, this.allowsSameNameSiblings);
        }

        public void setName(InternalQName name) {
            this.name = name;
        }

        public void setDefaultPrimaryType(InternalQName defaultPrimaryType) {
            this.defaultPrimaryType = defaultPrimaryType;
        }

        public void setRequiredPrimaryTypes(InternalQName[] requiredPrimaryTypes) {
            this.requiredPrimaryTypes = requiredPrimaryTypes;
        }

        public void setAutoCreated(boolean isAutoCreated) {
            this.isAutoCreated = isAutoCreated;
        }

        public void setOnParentVersion(int onParentVersion) {
            this.onParentVersion = onParentVersion;
        }

        public void setProtected(boolean isProtected) {
            this.isProtected = isProtected;
        }

        public void setMandatory(boolean isMandatory) {
            this.isMandatory = isMandatory;
        }

        public void setAllowsSameNameSiblings(boolean allowsSameNameSiblings) {
            this.allowsSameNameSiblings = allowsSameNameSiblings;
        }
    }
}

