/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application.localization;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.LocalePolicy;
import org.picocontainer.Startable;

public class DefaultLocalePolicyService
implements LocalePolicy,
Startable {
    public Locale determineLocale(LocaleContextInfo context) {
        Locale locale = null;
        locale = context.getRemoteUser() == null ? this.getLocaleConfigForAnonymous(context) : this.getLocaleConfigForRegistered(context);
        if (locale == null) {
            locale = context.getPortalLocale();
        }
        return locale;
    }

    protected Locale getLocaleConfigForRegistered(LocaleContextInfo context) {
        Locale locale = context.getLocaleIfLangSupported(context.getUserProfileLocale());
        if (locale == null) {
            locale = this.getLocaleConfigFromCookie(context);
        }
        if (locale == null) {
            locale = this.getLocaleConfigFromSession(context);
        }
        if (locale == null) {
            locale = this.getLocaleConfigFromBrowser(context);
        }
        return locale;
    }

    protected Locale getLocaleConfigFromBrowser(LocaleContextInfo context) {
        Iterator i$;
        List locales = context.getBrowserLocales();
        if (locales != null && (i$ = locales.iterator()).hasNext()) {
            Locale loc = (Locale)i$.next();
            return context.getLocaleIfLangSupported(loc);
        }
        return null;
    }

    protected Locale getLocaleConfigForAnonymous(LocaleContextInfo context) {
        Locale locale = this.getLocaleConfigFromCookie(context);
        if (locale == null) {
            locale = this.getLocaleConfigFromSession(context);
        }
        if (locale == null) {
            locale = this.getLocaleConfigFromBrowser(context);
        }
        return locale;
    }

    protected Locale getLocaleConfigFromSession(LocaleContextInfo context) {
        return context.getSessionLocale();
    }

    protected Locale getLocaleConfigFromCookie(LocaleContextInfo context) {
        Iterator i$;
        List locales = context.getCookieLocales();
        if (locales != null && (i$ = locales.iterator()).hasNext()) {
            Locale locale = (Locale)i$.next();
            return context.getLocaleIfLangSupported(locale);
        }
        return null;
    }

    public void start() {
    }

    public void stop() {
    }
}

