/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.component;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.FbType;
import net.fortuna.ical4j.model.property.Contact;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStamp;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.FreeBusy;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Url;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.util.PropertyValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VFreeBusy
extends CalendarComponent {
    private static final long serialVersionUID = 1046534053331139832L;
    private transient Log log = LogFactory.getLog((Class)VFreeBusy.class);

    public VFreeBusy() {
        super("VFREEBUSY");
        this.getProperties().add(new DtStamp());
    }

    public VFreeBusy(PropertyList properties) {
        super("VFREEBUSY", properties);
    }

    public VFreeBusy(DateTime start, DateTime end) {
        this();
        this.getProperties().add(new DtStart(start, true));
        this.getProperties().add(new DtEnd(end, true));
    }

    public VFreeBusy(DateTime start, DateTime end, Dur duration) {
        this();
        this.getProperties().add(new DtStart(start, true));
        this.getProperties().add(new DtEnd(end, true));
        this.getProperties().add(new Duration(duration));
    }

    public VFreeBusy(VFreeBusy request, ComponentList components) {
        this();
        DtStart start = (DtStart)request.getProperty("DTSTART");
        DtEnd end = (DtEnd)request.getProperty("DTEND");
        Duration duration = (Duration)request.getProperty("DURATION");
        this.getProperties().add(new DtStart(start.getDate(), true));
        this.getProperties().add(new DtEnd(end.getDate(), true));
        if (duration != null) {
            this.getProperties().add(new Duration(duration.getDuration()));
            DateTime freeStart = new DateTime(start.getDate());
            DateTime freeEnd = new DateTime(end.getDate());
            FreeBusy fb = this.createFreeTime(freeStart, freeEnd, duration.getDuration(), components);
            if (fb != null && !fb.getPeriods().isEmpty()) {
                this.getProperties().add(fb);
            }
        } else {
            DateTime busyEnd;
            DateTime busyStart = new DateTime(start.getDate());
            FreeBusy fb = this.createBusyTime(busyStart, busyEnd = new DateTime(end.getDate()), components);
            if (fb != null && !fb.getPeriods().isEmpty()) {
                this.getProperties().add(fb);
            }
        }
    }

    private FreeBusy createBusyTime(DateTime start, DateTime end, ComponentList components) {
        PeriodList periods = this.getConsumedTime(components, start, end);
        periods.setUtc(true);
        Iterator i = periods.iterator();
        while (i.hasNext()) {
            Period period = (Period)i.next();
            if (!period.getStart().after(end) && !period.getEnd().before(start)) continue;
            periods.remove(period);
        }
        return new FreeBusy(periods);
    }

    private FreeBusy createFreeTime(DateTime start, DateTime end, Dur duration, ComponentList components) {
        Duration freeDuration;
        FreeBusy fb = new FreeBusy();
        fb.getParameters().add(FbType.FREE);
        PeriodList periods = this.getConsumedTime(components, start, end);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Busy periods: " + periods));
        }
        DateTime lastPeriodEnd = null;
        if (periods.isEmpty()) {
            lastPeriodEnd = new DateTime(start);
        }
        Iterator i = periods.iterator();
        while (i.hasNext()) {
            Duration freeDuration2;
            Period period = (Period)i.next();
            if (period.getStart().after(end) || period.getEnd().before(start)) continue;
            if (lastPeriodEnd == null && period.getStart().after(start)) {
                lastPeriodEnd = new DateTime(start);
            }
            if (lastPeriodEnd != null && (freeDuration2 = new Duration(lastPeriodEnd, period.getStart())).getDuration().compareTo(duration) >= 0) {
                fb.getPeriods().add(new Period(lastPeriodEnd, freeDuration2.getDuration()));
            }
            lastPeriodEnd = period.getEnd();
        }
        if (lastPeriodEnd != null && (freeDuration = new Duration(lastPeriodEnd, end)).getDuration().compareTo(duration) >= 0) {
            fb.getPeriods().add(new Period(lastPeriodEnd, freeDuration.getDuration()));
        }
        return fb;
    }

    private PeriodList getConsumedTime(ComponentList components, DateTime rangeStart, DateTime rangeEnd) {
        PeriodList periods = new PeriodList();
        Iterator i = components.iterator();
        while (i.hasNext()) {
            Component component = (Component)i.next();
            if (!(component instanceof VEvent)) continue;
            periods.addAll(((VEvent)component).getConsumedTime(rangeStart, rangeEnd));
        }
        return periods.normalise();
    }

    public final void validate(boolean recurse) throws ValidationException {
        if (!CompatibilityHints.isHintEnabled("ical4j.validation.relaxed")) {
            PropertyValidator.getInstance().assertOne("UID", this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTAMP", this.getProperties());
        }
        PropertyValidator validator = PropertyValidator.getInstance();
        validator.assertOneOrLess("CONTACT", this.getProperties());
        validator.assertOneOrLess("DTSTART", this.getProperties());
        validator.assertOneOrLess("DTEND", this.getProperties());
        validator.assertOneOrLess("DURATION", this.getProperties());
        validator.assertOneOrLess("DTSTAMP", this.getProperties());
        validator.assertOneOrLess("ORGANIZER", this.getProperties());
        validator.assertOneOrLess("UID", this.getProperties());
        validator.assertOneOrLess("URL", this.getProperties());
        validator.assertNone("RRULE", this.getProperties());
        validator.assertNone("EXRULE", this.getProperties());
        validator.assertNone("RDATE", this.getProperties());
        validator.assertNone("EXDATE", this.getProperties());
        DtStart dtStart = (DtStart)this.getProperty("DTSTART");
        DtEnd dtEnd = (DtEnd)this.getProperty("DTEND");
        if (dtStart != null && dtEnd != null && !dtStart.getDate().before(dtEnd.getDate())) {
            throw new ValidationException("Property [DTEND] must be later in time than [DTSTART]");
        }
        if (recurse) {
            this.validateProperties();
        }
    }

    public final Contact getContact() {
        return (Contact)this.getProperty("CONTACT");
    }

    public final DtStart getStartDate() {
        return (DtStart)this.getProperty("DTSTART");
    }

    public final DtEnd getEndDate() {
        return (DtEnd)this.getProperty("DTEND");
    }

    public final Duration getDuration() {
        return (Duration)this.getProperty("DURATION");
    }

    public final DtStamp getDateStamp() {
        return (DtStamp)this.getProperty("DTSTAMP");
    }

    public final Organizer getOrganizer() {
        return (Organizer)this.getProperty("ORGANIZER");
    }

    public final Url getUrl() {
        return (Url)this.getProperty("URL");
    }

    public final Uid getUid() {
        return (Uid)this.getProperty("UID");
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.log = LogFactory.getLog((Class)VFreeBusy.class);
    }
}

