/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.text.ParseException;
import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.parameter.TzId;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.util.Strings;

public abstract class DateListProperty
extends Property {
    private DateList dates;
    private TimeZone timezone;

    public DateListProperty(String name) {
        super(name);
        this.dates = new DateList(Value.DATE_TIME);
    }

    public DateListProperty(String name, ParameterList parameters) {
        super(name, parameters);
    }

    public DateListProperty(String name, DateList dates) {
        super(name);
        this.dates = dates;
    }

    public DateListProperty(String name, ParameterList parameters, DateList dates) {
        super(name, parameters);
        this.dates = dates;
    }

    public final DateList getDates() {
        return this.dates;
    }

    public void setValue(String aValue) throws ParseException {
        this.dates = new DateList(aValue, (Value)this.getParameter("VALUE"), this.timezone);
    }

    public String getValue() {
        return Strings.valueOf(this.dates);
    }

    public void setTimeZone(TimeZone timezone) {
        if (this.dates == null) {
            throw new UnsupportedOperationException("TimeZone is not applicable to current value");
        }
        this.timezone = timezone;
        if (timezone != null) {
            if (!Value.DATE_TIME.equals(this.getDates().getType())) {
                throw new UnsupportedOperationException("TimeZone is not applicable to current value");
            }
            this.dates.setTimeZone(timezone);
            this.getParameters().remove(this.getParameter("TZID"));
            TzId tzId = new TzId(timezone.getID());
            this.getParameters().replace(tzId);
        } else {
            this.setUtc(false);
        }
    }

    public final void setUtc(boolean utc) {
        if (this.dates == null || !Value.DATE_TIME.equals(this.dates.getType())) {
            throw new UnsupportedOperationException("TimeZone is not applicable to current value");
        }
        this.dates.setUtc(utc);
        this.getParameters().remove(this.getParameter("TZID"));
    }
}

