/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.config;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.SimpleParameterEntry;
import org.exoplatform.services.jcr.util.StringNumberParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MappedParametrizedObjectEntry {
    protected String type;
    protected List<SimpleParameterEntry> parameters = new ArrayList<SimpleParameterEntry>();

    public MappedParametrizedObjectEntry() {
    }

    public MappedParametrizedObjectEntry(String type, List parameters) {
        this.type = type;
        this.parameters = parameters;
    }

    public List<SimpleParameterEntry> getParameters() {
        return this.parameters;
    }

    public String getParameterValue(String name) throws RepositoryConfigurationException {
        String value = this.getParameterValue(name, null);
        if (value == null) {
            throw new RepositoryConfigurationException("Parameter " + name + " not found ");
        }
        return value;
    }

    public String getParameterValue(String name, String defaultValue) {
        String value = defaultValue;
        for (int i = 0; i < this.parameters.size(); ++i) {
            SimpleParameterEntry p = this.parameters.get(i);
            if (!p.getName().equals(name)) continue;
            value = p.getValue();
            break;
        }
        return value;
    }

    public void putParameterValue(String name, String value) {
        for (SimpleParameterEntry p : this.parameters) {
            if (!p.getName().equals(name)) continue;
            p.setValue(value);
            return;
        }
        SimpleParameterEntry newParam = new SimpleParameterEntry(name, value);
        this.parameters.add(newParam);
    }

    public Integer getParameterInteger(String name, Integer defaultValue) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            SimpleParameterEntry p = this.parameters.get(i);
            if (!p.getName().equals(name)) continue;
            try {
                return StringNumberParser.parseInt(p.getValue());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public void putIntegerParameter(String name, Integer value) {
        for (SimpleParameterEntry param : this.parameters) {
            if (!param.getName().equals(name)) continue;
            param.setValue(value.toString());
            return;
        }
        SimpleParameterEntry newParam = new SimpleParameterEntry(name, value.toString());
        this.parameters.add(newParam);
    }

    public Integer getParameterInteger(String name) throws RepositoryConfigurationException {
        try {
            return StringNumberParser.parseInt(this.getParameterValue(name));
        }
        catch (NumberFormatException e) {
            throw new RepositoryConfigurationException(name + ": unparseable Integer. " + e, e);
        }
    }

    public Long getParameterLong(String name, Long defaultValue) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            SimpleParameterEntry p = this.parameters.get(i);
            if (!p.getName().equals(name)) continue;
            try {
                return StringNumberParser.parseLong(p.getValue());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public Long getParameterLong(String name) throws RepositoryConfigurationException {
        try {
            return StringNumberParser.parseLong(this.getParameterValue(name));
        }
        catch (NumberFormatException e) {
            throw new RepositoryConfigurationException(name + ": unparseable Long. " + e, e);
        }
    }

    public Long getParameterTime(String name, Long defaultValue) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            SimpleParameterEntry p = this.parameters.get(i);
            if (!p.getName().equals(name)) continue;
            try {
                return StringNumberParser.parseTime(p.getValue());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public Long getParameterTime(String name) throws RepositoryConfigurationException {
        try {
            return StringNumberParser.parseTime(this.getParameterValue(name));
        }
        catch (NumberFormatException e) {
            throw new RepositoryConfigurationException(name + ": unparseable time (as Long). " + e, e);
        }
    }

    public Boolean getParameterBoolean(String name, Boolean defaultValue) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            SimpleParameterEntry p = this.parameters.get(i);
            if (!p.getName().equals(name)) continue;
            return new Boolean(p.getValue());
        }
        return defaultValue;
    }

    public void putBooleanParameter(String name, Boolean value) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            SimpleParameterEntry p = this.parameters.get(i);
            if (!p.getName().equals(name)) continue;
            p.setValue(value.toString());
            return;
        }
        SimpleParameterEntry newParam = new SimpleParameterEntry(name, value.toString());
        this.parameters.add(newParam);
    }

    public Boolean getParameterBoolean(String name) throws RepositoryConfigurationException {
        return new Boolean(this.getParameterValue(name));
    }

    public String getType() {
        return this.type;
    }

    public void setParameters(List<SimpleParameterEntry> parameters) {
        this.parameters = parameters;
    }

    public void setType(String type) {
        this.type = type;
    }
}

