/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wsqa.httpclient;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.exoplatform.wsqa.httpclient.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequestHeader
extends LinkedHashMap<String, String> {
    public static final String USER_AGENT_FIREFOX = "Mozilla/5.0 (Macintosh; U; Intel Mac OS X; en-US; rv:1.8.1.4) Gecko/20070515 Firefox/2.0.0.4";
    private String method_;
    private URI uri_;
    private String protocolVersion_;
    private byte[] originalData_;

    public HttpRequestHeader() {
        this.setHost("localhost:8080");
        this.setUserAgent(USER_AGENT_FIREFOX);
        this.setAccept("text/xml,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5");
        this.setAcceptLanguage("en-us,en;q=0.5");
        this.setAcceptCharset("UTF-8,*");
        this.setKeepAlive("300");
        this.setProxyConnection("keep-alive");
    }

    public HttpRequestHeader(InputStream is) throws Exception {
        ByteArrayOutputStream line = new ByteArrayOutputStream();
        ByteArrayOutputStream rdata = new ByteArrayOutputStream();
        String firstline = null;
        int i = 0;
        boolean keepReading = true;
        while (keepReading) {
            ++i;
            int code = is.read();
            if (code <= 0) break;
            rdata.write(code);
            line.write(code);
            if (code != 10) continue;
            if (firstline == null) {
                firstline = new String(line.toByteArray()).trim();
                this.parseFirstLine(firstline);
            } else if (line.size() < 3) {
                keepReading = false;
            } else {
                String headerLine = new String(line.toByteArray());
                int colonIndex = headerLine.indexOf(58);
                String name = headerLine.substring(0, colonIndex);
                String value = headerLine.substring(colonIndex + 1, headerLine.length()).trim();
                this.put(name, value);
            }
            line.reset();
        }
        this.originalData_ = rdata.toByteArray();
    }

    public byte[] getOriginalData() {
        return this.originalData_;
    }

    private void parseFirstLine(String firstline) throws Exception {
        String[] tmp = firstline.split(" ");
        if (tmp.length != 3) {
            throw new Exception("Cannot  parse the first line: " + firstline);
        }
        this.setMethod(tmp[0]);
        this.setUri(new URI(tmp[1]));
        this.setProtocol(tmp[2]);
    }

    public String getHost() {
        return (String)this.get("Host");
    }

    public void setHost(String host) {
        this.put("Host", host);
    }

    public String getUserAgent() {
        return (String)this.get("User-Agent");
    }

    public void setUserAgent(String s) {
        this.put("User-Agent", s);
    }

    public String getAccept() {
        return (String)this.get("Accept");
    }

    public void setAccept(String s) {
        this.put("Accept", s);
    }

    public String getAcceptLanguage() {
        return (String)this.get("Accept-Language");
    }

    public void setAcceptLanguage(String s) {
        this.put("Accept-Language", s);
    }

    public String getAcceptEncoding() {
        return (String)this.get("Accept-Encoding");
    }

    public void setAcceptEncoding(String s) {
        this.put("Accept-Encoding", s);
    }

    public String getAcceptCharset() {
        return (String)this.get("Accept-Charset");
    }

    public void setAcceptCharset(String s) {
        this.put("Accept-Charset", s);
    }

    public String getContentType() {
        return (String)this.get("Content-Type");
    }

    public void setContentType(String s) {
        this.put("Content-Type", s);
    }

    public String getContentLength() {
        return (String)this.get("Content-Length");
    }

    public void setContentLength(String s) {
        this.put("Content-Length", s);
    }

    public void setContentLength(int length) {
        this.put("Content-Length", Integer.toString(length));
    }

    public String getKeepAlive() {
        return (String)this.get("Keep-Alive");
    }

    public void setKeepAlive(String s) {
        this.put("Keep-Alive", s);
    }

    public String getProxyConnection() {
        return (String)this.get("Proxy-Connection");
    }

    public void setProxyConnection(String s) {
        this.put("Proxy-Connection", s);
    }

    public String getCookie() {
        return (String)this.get("Cookie");
    }

    public void setCookie(String s) {
        this.put("Cookie", s);
    }

    public String getReferer() {
        return (String)this.get("Referer");
    }

    public void setReferer(String s) {
        this.put("Referer", s);
    }

    public String getIfModifiedSince() {
        return (String)this.get("If-Modified-Since");
    }

    public void setIfModifiedSince(String s) {
        this.put("If-Modified-Since", s);
    }

    public String getIfNoneMatch() {
        return (String)this.get("If-None-Match");
    }

    public void setIfNoneMatch(String s) {
        this.put("If-None-Match", s);
    }

    public String getProtocol() {
        return this.protocolVersion_;
    }

    public void setProtocol(String s) {
        this.protocolVersion_ = s;
    }

    public String getMethod() {
        return this.method_;
    }

    public void setMethod(String s) {
        this.method_ = s;
    }

    public URI getUri() {
        return this.uri_;
    }

    public void setUri(URI uri) {
        this.uri_ = uri;
    }

    public byte[] toBytes() {
        StringBuilder b = new StringBuilder();
        b.append(this.getMethod()).append(' ').append(this.getUri().getURI()).append(' ').append(this.getProtocol()).append("\r\n");
        for (Map.Entry entry : this.entrySet()) {
            b.append((String)entry.getKey()).append(": ").append((String)entry.getValue()).append("\r\n");
        }
        b.append("\r\n");
        return b.toString().getBytes();
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getMethod()).append(' ').append(this.getUri().getURI()).append(' ').append(this.getProtocol()).append("\r\n");
        for (Map.Entry entry : this.entrySet()) {
            b.append((String)entry.getKey()).append(": ").append((String)entry.getValue()).append("\r\n");
        }
        return b.toString();
    }
}

