/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wsqa.swing;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.exoplatform.swing.ViewPlugin;
import org.exoplatform.wsqa.httpclient.WebUnitExecuteContext;
import org.exoplatform.wsqa.swing.HttpClientResultPanel;

public class HttpClientLogViewPlugin
extends JPanel
implements ViewPlugin {
    public static final String NAME = "HttpClientLogViewPlugin";
    private static HttpClientLogViewPlugin singleton_ = new HttpClientLogViewPlugin();
    private HttpClientResultModel httpClientResultModel_;
    private static JTree jtree_;
    private DefaultMutableTreeNode selectNode_ = null;
    private HttpClientResultPanel resultPanel_;

    private HttpClientLogViewPlugin() {
        this.setName(NAME);
        this.setLayout(new CardLayout());
        JSplitPane splitPane = new JSplitPane();
        splitPane.setDividerSize(5);
        splitPane.setDividerLocation(250);
        this.add((Component)splitPane, "ScrollPane");
        JScrollPane scrollPane = new JScrollPane();
        this.httpClientResultModel_ = new HttpClientResultModel("Suites");
        jtree_ = new JTree(this.httpClientResultModel_);
        jtree_.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                HttpClientLogViewPlugin.this.selectNode_ = (DefaultMutableTreeNode)evt.getPath().getLastPathComponent();
                HttpClientLogViewPlugin.this.setSelectNode(HttpClientLogViewPlugin.this.selectNode_);
            }
        });
        final HttpClientNodePopupMenu popup = new HttpClientNodePopupMenu();
        jtree_.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                if (evt.getButton() == 3) {
                    popup.show((JComponent)evt.getSource(), evt.getX(), evt.getY());
                    jtree_.updateUI();
                }
            }
        });
        scrollPane.setViewportView(jtree_);
        splitPane.setLeftComponent(scrollPane);
        this.resultPanel_ = new HttpClientResultPanel();
        splitPane.setRightComponent(this.resultPanel_);
    }

    public String getTitle() {
        return "Http Client Log";
    }

    public static HttpClientLogViewPlugin getInstance() {
        return singleton_;
    }

    public void setSelectNode(DefaultMutableTreeNode selectNode) {
        this.selectNode_ = selectNode;
        try {
            if (selectNode != null && selectNode instanceof HttpClientNodeModel) {
                HttpClientNodeModel selectClientNode = (HttpClientNodeModel)selectNode;
                this.resultPanel_.updateData(selectClientNode.datas_);
            } else {
                this.resultPanel_.updateData(null);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addData(WebUnitExecuteContext context) throws Exception {
        HttpClientNodeModel clientNode;
        String clientId = context.getHttpClient().getId();
        String suiteName = context.getHttpClient().getSuiteName();
        DefaultMutableTreeNode suiteNode = (DefaultMutableTreeNode)this.httpClientResultModel_.suites_.get(suiteName);
        if (suiteNode == null) {
            suiteNode = this.httpClientResultModel_.addSuite(suiteName);
            DefaultTreeModel model = (DefaultTreeModel)jtree_.getModel();
            model.nodeStructureChanged(this.httpClientResultModel_);
        }
        if ((clientNode = (HttpClientNodeModel)this.httpClientResultModel_.clients_.get(clientId)) == null) {
            clientNode = new HttpClientNodeModel(clientId);
            suiteNode.add(clientNode);
            this.httpClientResultModel_.clients_.put(clientId, clientNode);
            DefaultTreeModel model = (DefaultTreeModel)jtree_.getModel();
            model.nodeStructureChanged(suiteNode);
        }
        if (clientNode == this.selectNode_) {
            this.resultPanel_.addData(context);
        } else {
            clientNode.datas_.add(context);
        }
    }

    public static class HttpClientNodeModel
    extends DefaultMutableTreeNode {
        List<WebUnitExecuteContext> datas_ = new ArrayList<WebUnitExecuteContext>();

        public HttpClientNodeModel(String label) {
            super(label);
        }
    }

    public static class HttpClientResultModel
    extends DefaultMutableTreeNode {
        private Map<String, DefaultMutableTreeNode> suites_ = new HashMap<String, DefaultMutableTreeNode>();
        private Map<String, HttpClientNodeModel> clients_ = new HashMap<String, HttpClientNodeModel>();

        public HttpClientResultModel(String label) {
            super(label);
        }

        public DefaultMutableTreeNode addSuite(String suiteName) {
            DefaultMutableTreeNode suiteNode = new DefaultMutableTreeNode(suiteName);
            this.add(suiteNode);
            this.suites_.put(suiteName, suiteNode);
            return suiteNode;
        }

        public void removeNode(DefaultMutableTreeNode node) {
            if (node == null) {
                return;
            }
            if (node instanceof HttpClientNodeModel) {
                DefaultMutableTreeNode suiteNode = (DefaultMutableTreeNode)node.getParent();
                suiteNode.remove(node);
            } else {
                String suiteName = (String)node.getUserObject();
                DefaultMutableTreeNode suiteNode = this.suites_.remove(suiteName);
                int childrenSize = suiteNode.getChildCount();
                for (int i = 0; i < childrenSize; ++i) {
                    HttpClientNodeModel child = (HttpClientNodeModel)suiteNode.getChildAt(i);
                    String id = (String)child.getUserObject();
                    this.clients_.remove(id);
                }
                this.remove(suiteNode);
            }
        }
    }

    class HttpClientNodePopupMenu
    extends JPopupMenu {
        public HttpClientNodePopupMenu() {
            JMenuItem menuItemDelete = new JMenuItem("Delete");
            menuItemDelete.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    String MESSAGE = "Are you sure want to delete?";
                    int result = JOptionPane.showConfirmDialog(null, "Are you sure want to delete?", "Confirm", 2, 2);
                    if (result == 0) {
                        HttpClientLogViewPlugin.this.httpClientResultModel_.removeNode(HttpClientLogViewPlugin.this.selectNode_);
                        HttpClientLogViewPlugin.this.setSelectNode(null);
                        jtree_.setSelectionRow(0);
                        DefaultTreeModel model = (DefaultTreeModel)jtree_.getModel();
                        model.nodeStructureChanged(HttpClientLogViewPlugin.this.httpClientResultModel_);
                    }
                }
            });
            this.add(menuItemDelete);
        }
    }
}

