/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.core;

import java.io.Writer;
import java.util.Map;
import java.util.Set;
import javax.portlet.WindowState;
import org.apache.commons.collections.map.HashedMap;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupMessages;

@Serialized
public abstract class UIPortletApplication
extends UIApplication {
    private int minWidth = 300;
    private int minHeight = 300;
    private Map<String, UIPopupMessages> _uiPopupMessages = new HashedMap();
    public static String VIEW_MODE = "ViewMode";
    public static String EDIT_MODE = "EditMode";
    public static String HELP_MODE = "HelpMode";
    public static String CONFIG_MODE = "ConfigMode";

    public UIPopupMessages getUIPopupMessages() {
        PortletRequestContext pContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        String currMode = pContext.getApplicationMode().toString();
        if (!this._uiPopupMessages.containsKey(currMode)) {
            try {
                UIPopupMessages popMsg = (UIPopupMessages)this.createUIComponent(UIPopupMessages.class, null, null);
                popMsg.setId("_" + popMsg.hashCode());
                this._uiPopupMessages.put(currMode, popMsg);
            }
            catch (Exception e) {
                return null;
            }
        }
        return this._uiPopupMessages.get(currMode);
    }

    @Deprecated
    public int getMinWidth() {
        return this.minWidth;
    }

    @Deprecated
    public void setMinWidth(int minWidth) {
        this.minWidth = minWidth;
    }

    @Deprecated
    public int getMinHeight() {
        return this.minHeight;
    }

    @Deprecated
    public void setMinHeight(int minHeight) {
        this.minHeight = minHeight;
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        WindowState currentWindowState = ((PortletRequestContext)context).getRequest().getWindowState();
        if (currentWindowState == WindowState.MINIMIZED) {
            return;
        }
        WebuiRequestContext pContext = (WebuiRequestContext)context.getParentAppRequestContext();
        if (context.useAjax() && !pContext.getFullRender()) {
            Writer w = context.getWriter();
            Set list = context.getUIComponentToUpdateByAjax();
            if (list != null) {
                if (this.getUIPopupMessages().hasMessage()) {
                    context.addUIComponentToUpdateByAjax((UIComponent)this.getUIPopupMessages());
                }
                for (UIComponent uicomponent : list) {
                    this.renderBlockToUpdate(uicomponent, context, w);
                }
                return;
            }
        }
        super.processRender(context);
    }
}

