/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.eval.forked;

import org.apache.poi.hssf.record.formula.eval.BlankEval;
import org.apache.poi.hssf.record.formula.eval.BoolEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.StringEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.ss.formula.EvaluationCell;
import org.apache.poi.ss.formula.EvaluationSheet;
import org.apache.poi.ss.formula.eval.forked.ForkedEvaluationSheet;
import org.apache.poi.ss.usermodel.Cell;

final class ForkedEvaluationCell
implements EvaluationCell {
    private final EvaluationSheet _sheet;
    private final EvaluationCell _masterCell;
    private boolean _booleanValue;
    private int _cellType;
    private int _errorValue;
    private double _numberValue;
    private String _stringValue;

    public ForkedEvaluationCell(ForkedEvaluationSheet sheet, EvaluationCell masterCell) {
        this._sheet = sheet;
        this._masterCell = masterCell;
        this.setValue(BlankEval.instance);
    }

    public Object getIdentityKey() {
        return this._masterCell.getIdentityKey();
    }

    public void setValue(ValueEval value) {
        Class<?> cls = value.getClass();
        if (cls == NumberEval.class) {
            this._cellType = 0;
            this._numberValue = ((NumberEval)value).getNumberValue();
            return;
        }
        if (cls == StringEval.class) {
            this._cellType = 1;
            this._stringValue = ((StringEval)value).getStringValue();
            return;
        }
        if (cls == BoolEval.class) {
            this._cellType = 4;
            this._booleanValue = ((BoolEval)value).getBooleanValue();
            return;
        }
        if (cls == ErrorEval.class) {
            this._cellType = 5;
            this._errorValue = ((ErrorEval)value).getErrorCode();
            return;
        }
        if (cls == BlankEval.class) {
            this._cellType = 3;
            return;
        }
        throw new IllegalArgumentException("Unexpected value class (" + cls.getName() + ")");
    }

    public void copyValue(Cell destCell) {
        switch (this._cellType) {
            case 3: {
                destCell.setCellType(3);
                return;
            }
            case 0: {
                destCell.setCellValue(this._numberValue);
                return;
            }
            case 4: {
                destCell.setCellValue(this._booleanValue);
                return;
            }
            case 1: {
                destCell.setCellValue(this._stringValue);
                return;
            }
            case 5: {
                destCell.setCellErrorValue((byte)this._errorValue);
                return;
            }
        }
        throw new IllegalStateException("Unexpected data type (" + this._cellType + ")");
    }

    private void checkCellType(int expectedCellType) {
        if (this._cellType != expectedCellType) {
            throw new RuntimeException("Wrong data type (" + this._cellType + ")");
        }
    }

    public int getCellType() {
        return this._cellType;
    }

    public boolean getBooleanCellValue() {
        this.checkCellType(4);
        return this._booleanValue;
    }

    public int getErrorCellValue() {
        this.checkCellType(5);
        return this._errorValue;
    }

    public double getNumericCellValue() {
        this.checkCellType(0);
        return this._numberValue;
    }

    public String getStringCellValue() {
        this.checkCellType(1);
        return this._stringValue;
    }

    public EvaluationSheet getSheet() {
        return this._sheet;
    }

    public int getRowIndex() {
        return this._masterCell.getRowIndex();
    }

    public int getColumnIndex() {
        return this._masterCell.getColumnIndex();
    }
}

