/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.workflow.impl.jbpm;

import java.util.Date;
import org.exoplatform.services.workflow.Task;
import org.jbpm.taskmgmt.exe.SwimlaneInstance;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class TaskData
implements Task {
    public static final String STARTED = "started";
    public static final String FINISHED = "finished";
    private TaskInstance taskInstance;
    private String imageURL_;

    public TaskData(TaskInstance taskInstance) {
        this.taskInstance = taskInstance;
    }

    public String getId() {
        return "" + this.taskInstance.getId();
    }

    public String getTaskName() {
        return this.taskInstance.getName();
    }

    public String getActorId() {
        SwimlaneInstance swimlane;
        String actorId = this.taskInstance.getActorId();
        if (actorId == null && (swimlane = this.taskInstance.getSwimlaneInstance()) != null) {
            actorId = swimlane.getActorId();
        }
        if (actorId == null) {
            actorId = "N/A";
        }
        return actorId;
    }

    public String getSwimlane() {
        return this.taskInstance.getSwimlaneInstance().getName();
    }

    public Date getEnd() {
        return this.taskInstance.getEnd();
    }

    public String getProcessId() {
        return "" + this.taskInstance.getToken().getProcessInstance().getProcessDefinition().getId();
    }

    public String getProcessInstanceId() {
        return "" + this.taskInstance.getToken().getProcessInstance().getId();
    }

    public String getDescription() {
        return this.taskInstance.getTask().getDescription();
    }
}

