/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol.conversion.jsonlib;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.Map;
import net.sf.ezmorph.Morpher;
import net.sf.ezmorph.MorpherRegistry;
import net.sf.json.JsonConfig;
import net.sf.json.util.EnumMorpher;
import net.sf.json.util.JSONUtils;
import org.apache.shindig.protocol.conversion.jsonlib.InjectorBeanInstanceStrategy;
import org.apache.shindig.protocol.conversion.jsonlib.JsonObjectToMapMorpher;
import org.apache.shindig.protocol.conversion.jsonlib.NullDefaultValueProcessor;
import org.apache.shindig.protocol.conversion.jsonlib.NullPropertyFilter;
import org.apache.shindig.protocol.model.Enum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseJsonLibConfig
extends JsonConfig {
    @Inject
    public BaseJsonLibConfig(Injector injector) {
        this.registerMorphers();
        this.setNewBeanInstanceStrategy(new InjectorBeanInstanceStrategy(injector));
        this.registerDefaultValueProcessor(String.class, new NullDefaultValueProcessor());
        this.setJsonPropertyFilter(new NullPropertyFilter());
        this.setJavaPropertyFilter(new NullPropertyFilter());
        this.setClassMap(this.createClassMap());
    }

    protected void registerMorphers() {
        MorpherRegistry morpherRegistry = JSONUtils.getMorpherRegistry();
        morpherRegistry.registerMorpher((Morpher)new EnumMorpher(Enum.Field.class));
        morpherRegistry.registerMorpher((Morpher)new JsonObjectToMapMorpher());
    }

    protected Map<String, Class<?>> createClassMap() {
        return Maps.newHashMap();
    }
}

