/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.metadata;

import javax.jcr.nodetype.NodeType;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.metadata.UIMetadataForm;
import org.exoplatform.ecm.webui.component.admin.metadata.UIMetadataList;
import org.exoplatform.ecm.webui.component.admin.metadata.UIMetadataView;
import org.exoplatform.ecm.webui.selector.UIPermissionSelector;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.ext.manager.UIAbstractManager;

@ComponentConfig(lifecycle=UIContainerLifecycle.class)
public class UIMetadataManager
extends UIAbstractManager {
    public static final String METADATA_POPUP = "MetadataPopupEdit";
    public static final String VIEW_METADATA_POPUP = "ViewMetadataPopup";
    public static final String PERMISSION_POPUP = "PermissionPopup";

    public UIMetadataManager() throws Exception {
        this.addChild(UIMetadataList.class, null, null);
    }

    public void refresh() throws Exception {
        this.update();
    }

    public void update() throws Exception {
        ((UIMetadataList)this.getChild(UIMetadataList.class)).updateGrid();
    }

    public void initPopup() throws Exception {
        this.removeChildById(METADATA_POPUP);
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, METADATA_POPUP);
        uiPopup.setWindowSize(650, 450);
        UIMetadataForm uiMetaForm = (UIMetadataForm)this.createUIComponent(UIMetadataForm.class, null, null);
        uiPopup.setUIComponent((UIComponent)uiMetaForm);
        uiPopup.setRendered(true);
        uiPopup.setShow(true);
        uiPopup.setResizable(true);
    }

    public void initViewPopup(String metadataName) throws Exception {
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, VIEW_METADATA_POPUP);
        uiPopup.setShow(true);
        uiPopup.setWindowSize(600, 500);
        uiPopup.setRendered(true);
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        ExtendedNodeTypeManager ntManager = repositoryService.getRepository(repository).getNodeTypeManager();
        NodeType nodeType = ntManager.getNodeType(metadataName);
        UIMetadataView uiView = (UIMetadataView)uiPopup.createUIComponent(UIMetadataView.class, null, null);
        uiView.setMetadata(nodeType);
        uiPopup.setUIComponent((UIComponent)uiView);
        uiPopup.setResizable(true);
    }

    public void initPopupPermission(String membership) throws Exception {
        this.removeChildById(PERMISSION_POPUP);
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, PERMISSION_POPUP);
        uiPopup.setWindowSize(560, 300);
        UIPermissionSelector uiECMPermission = (UIPermissionSelector)this.createUIComponent(UIPermissionSelector.class, null, "MetadataPermission");
        uiECMPermission.setSelectedMembership(true);
        if (membership != null && membership.indexOf(":/") > -1) {
            String[] arrMember = membership.split(":/");
            uiECMPermission.setCurrentPermission("/" + arrMember[1]);
        }
        uiPopup.setUIComponent((UIComponent)uiECMPermission);
        UIMetadataForm uiForm = (UIMetadataForm)this.findFirstComponentOfType(UIMetadataForm.class);
        uiECMPermission.setSourceComponent((UIComponent)uiForm, null);
        uiPopup.setRendered(true);
        uiPopup.setShow(true);
    }
}

