/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.templates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.templates.UIDialogTab;
import org.exoplatform.ecm.webui.component.admin.templates.UISkinTab;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplateContent;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplateEditForm;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplateForm;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplatesManager;
import org.exoplatform.ecm.webui.component.admin.templates.UIViewTab;
import org.exoplatform.ecm.webui.component.admin.templates.UIViewTemplate;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="system:/groovy/ecm/webui/UIGridWithButton.gtmpl", events={@EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UITemplateList.msg.confirm-delete"), @EventConfig(listeners={AddNewActionListener.class})})
public class UITemplateList
extends UIGrid {
    private static String[] NODETYPE_BEAN_FIELD = new String[]{"name"};
    private static String[] NODETYPE_ACTION = new String[]{"Edit", "Delete"};

    public UITemplateList() throws Exception {
        this.getUIPageIterator().setId("NodeTypeListIterator");
        this.configure("name", NODETYPE_BEAN_FIELD, NODETYPE_ACTION);
    }

    public String[] getActions() {
        return new String[]{"AddNew"};
    }

    public void updateGrid(int currentPage) throws Exception {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        Node templatesHome = templateService.getTemplatesHome(repository, SessionProviderFactory.createSessionProvider());
        ArrayList<TemplateData> templateData = new ArrayList<TemplateData>();
        if (templatesHome != null) {
            NodeTypeManager ntManager = templatesHome.getSession().getWorkspace().getNodeTypeManager();
            NodeTypeIterator nodetypeIter = ntManager.getAllNodeTypes();
            ArrayList<String> listNodeTypeName = new ArrayList<String>();
            while (nodetypeIter.hasNext()) {
                NodeType n1 = nodetypeIter.nextNodeType();
                listNodeTypeName.add(n1.getName());
            }
            NodeIterator nodes = templatesHome.getNodes();
            while (nodes.hasNext()) {
                Node node = nodes.nextNode();
                if (!listNodeTypeName.contains(node.getName())) continue;
                templateData.add(new TemplateData(node.getName()));
            }
            Collections.sort(templateData, new TemplateComparator());
        }
        ObjectPageList objPageList = new ObjectPageList(templateData, 10);
        this.getUIPageIterator().setPageList((PageList)objPageList);
        if (currentPage > this.getUIPageIterator().getAvailablePage()) {
            this.getUIPageIterator().setCurrentPage(currentPage - 1);
        } else {
            this.getUIPageIterator().setCurrentPage(currentPage);
        }
    }

    public static class TemplateData {
        private String name;

        public TemplateData(String temp) {
            this.name = temp;
        }

        public String getName() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddNewActionListener
    extends EventListener<UITemplateList> {
        public void execute(Event<UITemplateList> event) throws Exception {
            UITemplatesManager uiTemplatesManager = (UITemplatesManager)((UITemplateList)((Object)event.getSource())).getAncestorOfType(UITemplatesManager.class);
            UITemplateForm uiTemplateForm = (UITemplateForm)uiTemplatesManager.createUIComponent(UITemplateForm.class, null, null);
            uiTemplatesManager.removeChildById("EditTemplatePopup");
            if (uiTemplateForm.getOption().size() == 0) {
                UIApplication uiApp = (UIApplication)((UITemplateList)((Object)event.getSource())).getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UITemplateList.msg.access-denied", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            uiTemplateForm.refresh();
            uiTemplatesManager.initPopup((UIComponent)uiTemplateForm, "TemplatePopup");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTemplatesManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UITemplateList> {
        public void execute(Event<UITemplateList> event) throws Exception {
            UITemplateList nodeTypeList = (UITemplateList)((Object)event.getSource());
            UITemplatesManager uiTemplatesManager = (UITemplatesManager)nodeTypeList.getParent();
            if (uiTemplatesManager.isEditingTemplate()) {
                UIApplication uiApp = (UIApplication)((UITemplateList)((Object)event.getSource())).getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UITemplateList.msg.editing-template", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            String nodeType = event.getRequestContext().getRequestParameter("objectId");
            TemplateService templateService = (TemplateService)nodeTypeList.getApplicationComponent(TemplateService.class);
            String repository = ((UIECMAdminPortlet)nodeTypeList.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
            templateService.removeManagedNodeType(nodeType, repository);
            nodeTypeList.updateGrid(nodeTypeList.getUIPageIterator().getCurrentPage());
            event.getRequestContext().addUIComponentToUpdateByAjax(nodeTypeList.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditActionListener
    extends EventListener<UITemplateList> {
        public void execute(Event<UITemplateList> event) throws Exception {
            UITemplateList nodeTypeList = (UITemplateList)((Object)event.getSource());
            String repository = ((UIECMAdminPortlet)nodeTypeList.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
            String nodeType = event.getRequestContext().getRequestParameter("objectId");
            UITemplatesManager uiTemplatesManager = (UITemplatesManager)nodeTypeList.getParent();
            UIViewTemplate uiViewTemplate = (UIViewTemplate)uiTemplatesManager.createUIComponent(UIViewTemplate.class, null, null);
            ((UITemplateEditForm)uiViewTemplate.getChild(UITemplateEditForm.class)).update(nodeType);
            uiViewTemplate.setNodeTypeName(nodeType);
            UIDialogTab uiDialogTab = (UIDialogTab)uiViewTemplate.findFirstComponentOfType(UIDialogTab.class);
            uiDialogTab.updateGrid(nodeType, repository);
            UITemplateContent uiDialogTabForm = (UITemplateContent)uiViewTemplate.findComponentById("DialogForm");
            uiDialogTabForm.setNodeTypeName(nodeType);
            uiDialogTabForm.update(null);
            UIViewTab uiViewTab = (UIViewTab)uiViewTemplate.findFirstComponentOfType(UIViewTab.class);
            uiViewTab.updateGrid(nodeType);
            UITemplateContent uiViewTabForm = (UITemplateContent)uiViewTemplate.findComponentById("ViewForm");
            uiViewTabForm.setNodeTypeName(nodeType);
            uiViewTabForm.update(null);
            UISkinTab uiSkinTab = (UISkinTab)uiViewTemplate.findFirstComponentOfType(UISkinTab.class);
            uiSkinTab.updateGrid(nodeType, repository);
            UITemplateContent uiSkinTabForm = (UITemplateContent)uiViewTemplate.findComponentById("SkinForm");
            uiSkinTabForm.setNodeTypeName(nodeType);
            uiSkinTabForm.update(null);
            uiTemplatesManager.removeChildById("TemplatePopup");
            uiTemplatesManager.initPopup((UIComponent)uiViewTemplate, "EditTemplatePopup");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTemplatesManager);
        }
    }

    public static class TemplateComparator
    implements Comparator {
        public int compare(Object o1, Object o2) throws ClassCastException {
            String name1 = ((TemplateData)o1).getName();
            String name2 = ((TemplateData)o2).getName();
            return name1.compareToIgnoreCase(name2);
        }
    }
}

