/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.upload;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.util.Iterator;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.commons.fileupload.FileItem;
import org.exoplatform.ide.upload.UploadServiceException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/services/loopbackcontent")
public class LoopbackContentService
implements ResourceContainer {
    private static Log log = ExoLogger.getLogger(LoopbackContentService.class);

    @POST
    @Consumes(value={"multipart/*"})
    @Produces(value={"text/html"})
    public String post(Iterator<FileItem> items) throws UploadServiceException {
        InputStream stream = null;
        while (items.hasNext()) {
            FileItem fitem = items.next();
            if (fitem.isFormField()) continue;
            try {
                stream = fitem.getInputStream();
            }
            catch (IOException ioe) {
                log.error((Object)ioe.getMessage(), (Throwable)ioe);
                throw new UploadServiceException(ioe.getMessage());
            }
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                String str = URLEncoder.encode(line + "\n", "UTF-8");
                sb.append(str);
            }
        }
        catch (IOException ioe) {
            log.error((Object)ioe.getMessage(), (Throwable)ioe);
            throw new UploadServiceException(ioe.getMessage());
        }
        String bodyString = sb.toString();
        return "<filecontent>" + bodyString + "</filecontent>";
    }
}

