/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.templates;

import com.google.inject.Inject;
import java.io.IOException;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.HtmlSerialization;
import org.apache.shindig.gadgets.templates.AbstractTagHandler;
import org.apache.shindig.gadgets.templates.TemplateProcessor;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HtmlTagHandler
extends AbstractTagHandler {
    static final String TAG_NAME = "Html";
    static final String ATTR_CODE = "code";
    private final GadgetHtmlParser parser;

    @Inject
    public HtmlTagHandler(GadgetHtmlParser parser) {
        super("http://ns.opensocial.org/2008/markup", TAG_NAME);
        this.parser = parser;
    }

    public void process(Node result, Element tag, TemplateProcessor processor) {
        String code = this.getValueFromTag(tag, ATTR_CODE, processor, String.class);
        if (code == null || "".equals(code)) {
            return;
        }
        try {
            this.parser.parseFragment(code, result);
        }
        catch (GadgetException ge) {
            try {
                StringBuilder sb = new StringBuilder("Error: ");
                HtmlSerialization.printEscapedText(ge.getMessage(), sb);
                Comment comment = result.getOwnerDocument().createComment(sb.toString());
                result.appendChild(comment);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

