/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.templates;

import com.google.inject.Inject;
import org.apache.shindig.gadgets.templates.AbstractTagHandler;
import org.apache.shindig.gadgets.templates.TemplateProcessor;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RepeatTagHandler
extends AbstractTagHandler {
    static final String TAG_REPEAT = "Repeat";
    static final String EXPRESSION_ATTR = "expression";
    static final String IF_ATTR = "if";

    @Inject
    public RepeatTagHandler() {
        super("http://ns.opensocial.org/2008/markup", TAG_REPEAT);
    }

    public void process(final Node result, final Element tag, final TemplateProcessor processor) {
        Iterable repeat = this.getValueFromTag(tag, EXPRESSION_ATTR, processor, Iterable.class);
        final Attr ifAttribute = tag.getAttributeNode(IF_ATTR);
        processor.processRepeat(result, tag, repeat, new Runnable(){

            public void run() {
                if (ifAttribute != null && !processor.evaluate(ifAttribute.getValue(), Boolean.class, false).booleanValue()) {
                    return;
                }
                processor.processChildNodes(result, tag);
            }
        });
    }
}

