/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore;

import com.arjuna.ats.arjuna.ArjunaNames;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreError;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.gandiva.ClassName;
import com.arjuna.ats.arjuna.gandiva.ObjectName;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.objectstore.ObjectStoreImple;
import com.arjuna.ats.arjuna.objectstore.jdbc.JDBCAccess;
import com.arjuna.ats.arjuna.state.InputBuffer;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputBuffer;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.objectstore.JDBCImple;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;

public class JDBCStore
extends ObjectStoreImple {
    protected boolean _isValid;
    protected JDBCImple _theImple;
    private JDBCAccess _jdbcAccess;
    private String _jdbcAccessClassName;
    private String _jdbcTableName;
    private static String _defaultTableName = "JBossTSTable";
    protected static final HashMap _theImples = new HashMap();
    protected static final HashMap _theAccesses = new HashMap();

    public String getStoreName() {
        if (this.storeValid()) {
            return this.getAccessClassName() + ":" + this.getTableName();
        }
        return "Invalid";
    }

    public int typeIs() {
        return 15;
    }

    public boolean commit_state(Uid objUid, String tName) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCStore.commit_state(" + objUid + ", " + tName + ")");
        }
        if (!this.storeValid()) {
            return false;
        }
        return this._theImple.commit_state(objUid, tName, this.getTableName());
    }

    public boolean hide_state(Uid objUid, String tName) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "ShadowingStore.hide_state(" + objUid + ", " + tName + ")");
        }
        if (this.storeValid()) {
            return this._theImple.hide_state(objUid, tName, this.getTableName());
        }
        return false;
    }

    public boolean reveal_state(Uid objUid, String tName) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "ShadowingStore.reveal_state(" + objUid + ", " + tName + ")");
        }
        if (this.storeValid()) {
            return this._theImple.reveal_state(objUid, tName, this.getTableName());
        }
        return false;
    }

    public int currentState(Uid objUid, String tName) throws ObjectStoreException {
        if (this.storeValid()) {
            return this._theImple.currentState(objUid, tName, this.getTableName());
        }
        return 0;
    }

    public InputObjectState read_committed(Uid storeUid, String tName) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCStore.read_committed(" + storeUid + ", " + tName + ")");
        }
        return this.read_state(storeUid, tName, 1);
    }

    public InputObjectState read_uncommitted(Uid storeUid, String tName) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCStore.read_uncommitted(" + storeUid + ", " + tName + ")");
        }
        return this.read_state(storeUid, tName, 2);
    }

    public boolean remove_committed(Uid storeUid, String tName) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCStore.remove_committed(" + storeUid + ", " + tName + ")");
        }
        return this.remove_state(storeUid, tName, 1);
    }

    public boolean remove_uncommitted(Uid storeUid, String tName) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCStore.remove_uncommitted(" + storeUid + ", " + tName + ")");
        }
        return this.remove_state(storeUid, tName, 2);
    }

    public boolean write_committed(Uid storeUid, String tName, OutputObjectState state) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCStore.write_committed(" + storeUid + ", " + tName + ")");
        }
        return this.write_state(storeUid, tName, state, 1);
    }

    public boolean write_uncommitted(Uid storeUid, String tName, OutputObjectState state) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCStore.write_uncommitted(" + storeUid + ", " + tName + ", " + state + ")");
        }
        return this.write_state(storeUid, tName, state, 2);
    }

    public final boolean storeValid() {
        return this._isValid;
    }

    public boolean allObjUids(String tName, InputObjectState state, int match) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCStore.allObjUids(" + tName + ", " + state + ", " + match + ")");
        }
        if (this.storeValid()) {
            return this._theImple.allObjUids(tName, state, match, this.getTableName());
        }
        return false;
    }

    public boolean allTypes(InputObjectState foundTypes) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCStore.allTypes(" + foundTypes + ")");
        }
        if (this.storeValid()) {
            return this._theImple.allTypes(foundTypes, this.getTableName());
        }
        return false;
    }

    public synchronized void packInto(OutputBuffer buff) throws IOException {
        buff.packString(this.getAccessClassName());
        buff.packString(this.getTableName());
    }

    public synchronized void unpackFrom(InputBuffer buff) throws IOException {
        this.setAccessClassName(buff.unpackString());
        this.setTableName(buff.unpackString());
    }

    public ClassName className() {
        return ArjunaNames.Implementation_ObjectStore_JDBCStore();
    }

    public static ClassName name() {
        return ArjunaNames.Implementation_ObjectStore_JDBCStore();
    }

    protected InputObjectState read_state(Uid objUid, String tName, int ft) throws ObjectStoreException {
        if (!this.storeValid()) {
            return null;
        }
        return this._theImple.read_state(objUid, tName, ft, this.getTableName());
    }

    protected boolean remove_state(Uid objUid, String name, int ft) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 2L, 16L, "JDBCStore.remove_state(" + objUid + ", " + name + ", " + ObjectStore.stateTypeString(ft) + ")");
        }
        if (!this.storeValid()) {
            return false;
        }
        return this._theImple.remove_state(objUid, name, ft, this.getTableName());
    }

    protected boolean write_state(Uid objUid, String tName, OutputObjectState state, int s) throws ObjectStoreException {
        if (!this.storeValid()) {
            return false;
        }
        return this._theImple.write_state(objUid, tName, state, s, this.getTableName());
    }

    public static JDBCStore create() {
        return new JDBCStore();
    }

    public static JDBCStore create(Object[] param) {
        if (param == null) {
            return null;
        }
        return new JDBCStore((String)param[0]);
    }

    public static JDBCStore create(ObjectName param) {
        if (param == null) {
            return null;
        }
        return new JDBCStore(param);
    }

    protected JDBCStore() {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(1L, 4L, 16L, this.getClass().getName() + "()");
        }
        try {
            this.initialise("");
        }
        catch (Exception e) {
            throw new ObjectStoreError();
        }
    }

    protected JDBCStore(String tableName) {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(1L, 4L, 16L, this.getClass().getName() + "(" + tableName + ")");
        }
        try {
            this.initialise(tableName);
        }
        catch (Exception e) {
            throw new ObjectStoreError();
        }
    }

    protected JDBCStore(ObjectName objName) {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(1L, 4L, 16L, this.getClass().getName() + "(" + objName + " )");
        }
        try {
            this.parseObjectName(objName);
        }
        catch (Exception e) {
            throw new ObjectStoreError();
        }
    }

    protected String getAccessClassName() {
        if (this._jdbcAccessClassName == null) {
            this._jdbcAccessClassName = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.objectstore.jdbcUserDbAccess");
        }
        return this._jdbcAccessClassName;
    }

    protected void setAccessClassName(String jdbcAccessClassName) {
        this._jdbcAccessClassName = jdbcAccessClassName;
    }

    protected String getDefaultTableName() {
        return _defaultTableName;
    }

    protected String getAccessClassNameFromObject(ObjectName objName) throws IOException {
        return objName.getStringAttribute("com.arjuna.ats.arjuna.objectstore.jdbcUserDbAccess");
    }

    protected String getTableNameFromObject(ObjectName objName) throws IOException {
        return objName.getStringAttribute(ArjunaNames.Implementation_ObjectStore_JDBC_tableName());
    }

    protected JDBCAccess getJDBCAccess() {
        return this._jdbcAccess;
    }

    protected void setJDBCAccess(JDBCAccess jdbcAccess) {
        this._jdbcAccess = jdbcAccess;
    }

    protected String getTableName() {
        return this._jdbcTableName;
    }

    protected void setTableName(String tableName) {
        this._jdbcTableName = tableName;
    }

    protected void initialise(String tableName) throws Exception {
        String jdbcAccessClassName = this.getAccessClassName();
        if (jdbcAccessClassName == null) {
            if (tsLogger.arjLoggerI18N.isFatalEnabled()) {
                tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.internal.arjuna.objectstore.JDBCStore_5");
            }
            throw new FatalError(tsLogger.log_mesg.getString("com.arjuna.ats.internal.arjuna.objectstore.JDBCStore_5"));
        }
        try {
            this.setupStore(jdbcAccessClassName, tableName);
        }
        catch (Exception e) {
            if (tsLogger.arjLoggerI18N.isFatalEnabled()) {
                tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.internal.arjuna.objectstore.JDBCStore_1", new Object[]{this.getJDBCAccess(), this.getTableName()});
            }
            throw e;
        }
        this._isValid = true;
    }

    protected void parseObjectName(ObjectName objName) throws Exception {
        String tableName;
        String jdbcAccessClassName;
        if (objName == null) {
            if (tsLogger.arjLoggerI18N.isFatalEnabled()) {
                tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.internal.arjuna.objectstore.JDBCStore_4", new Object[]{"null"});
            }
            throw new Exception();
        }
        try {
            jdbcAccessClassName = this.getAccessClassNameFromObject(objName);
            tableName = this.getTableNameFromObject(objName);
        }
        catch (Exception e) {
            if (tsLogger.arjLoggerI18N.isFatalEnabled()) {
                tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.internal.arjuna.objectstore.JDBCStore_4", new Object[]{objName});
            }
            throw e;
        }
        try {
            this.setupStore(jdbcAccessClassName, tableName);
        }
        catch (Exception e) {
            if (tsLogger.arjLoggerI18N.isFatalEnabled()) {
                tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.internal.arjuna.objectstore.JDBCStore_1", new Object[]{this.getJDBCAccess(), this.getTableName()});
            }
            throw e;
        }
        this._isValid = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupStore(String jdbcAccessClassName, String tableName) throws Exception {
        String jdbcAccessTableName;
        JDBCAccess jdbcAccess;
        if (jdbcAccessClassName == null || jdbcAccessClassName.length() == 0) {
            throw new ObjectStoreException();
        }
        HashMap hashMap = _theAccesses;
        synchronized (hashMap) {
            Object jdbcAccessObject = _theAccesses.get(jdbcAccessClassName);
            if (jdbcAccessObject != null) {
                jdbcAccess = (JDBCAccess)jdbcAccessObject;
            } else {
                try {
                    Class<?> jdbcAccessClass = Thread.currentThread().getContextClassLoader().loadClass(jdbcAccessClassName);
                    jdbcAccess = (JDBCAccess)jdbcAccessClass.newInstance();
                }
                catch (Exception ex) {
                    if (tsLogger.arjLoggerI18N.isFatalEnabled()) {
                        tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.internal.arjuna.objectstore.JDBCStore_2", new Object[]{ex, jdbcAccessClassName});
                    }
                    throw ex;
                }
                _theAccesses.put(jdbcAccessClassName, jdbcAccess);
            }
        }
        this.setJDBCAccess(jdbcAccess);
        String impleTableName = tableName != null && tableName.length() > 0 ? tableName : ((jdbcAccessTableName = jdbcAccess.tableName()) != null && jdbcAccessTableName.length() > 0 ? jdbcAccessTableName : this.getDefaultTableName());
        this.setTableName(impleTableName);
        String impleKey = jdbcAccessClassName + ":" + impleTableName;
        HashMap hashMap2 = _theImples;
        synchronized (hashMap2) {
            Object currentImple = _theImples.get(impleKey);
            if (currentImple != null) {
                this._theImple = (JDBCImple)currentImple;
            } else {
                try {
                    Connection connection;
                    try {
                        connection = jdbcAccess.getConnection();
                    }
                    catch (SQLException sqle) {
                        if (tsLogger.arjLoggerI18N.isFatalEnabled()) {
                            tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.internal.arjuna.objectstore.JDBCStore_2", new Object[]{sqle, "getConnection()"});
                        }
                        throw sqle;
                    }
                    if (connection == null) {
                        if (tsLogger.arjLoggerI18N.isFatalEnabled()) {
                            tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.internal.arjuna.objectstore.JDBCStore_1", new Object[]{this.getJDBCAccess(), this.getTableName()});
                        }
                        throw new SQLException("getConnection returned null");
                    }
                    boolean success = false;
                    try {
                        JDBCImple jdbcImple;
                        connection.setAutoCommit(true);
                        try {
                            Class jdbcImpleClass = this.getJDBCClass(connection);
                            jdbcImple = (JDBCImple)jdbcImpleClass.newInstance();
                            jdbcImple.setShareStatus(this.shareStatus);
                        }
                        catch (Exception ex) {
                            if (tsLogger.arjLoggerI18N.isFatalEnabled()) {
                                tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.internal.arjuna.objectstore.JDBCStore_2", new Object[]{ex, this.getJDBCAccess()});
                            }
                            throw ex;
                        }
                        if (!jdbcImple.initialise(connection, jdbcAccess, impleTableName)) {
                            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCStore_3");
                            }
                            throw new ObjectStoreException();
                        }
                        _theImples.put(impleKey, jdbcImple);
                        this._theImple = jdbcImple;
                        success = true;
                    }
                    finally {
                        if (!success) {
                            try {
                                connection.close();
                            }
                            catch (SQLException sqle) {}
                        }
                    }
                }
                catch (Exception e) {
                    tsLogger.arjLogger.warn(e.toString());
                    throw e;
                }
            }
            this._isValid = true;
        }
    }

    protected Class getJDBCClass(Connection conn) throws ClassNotFoundException, SQLException {
        DatabaseMetaData md = conn.getMetaData();
        String name = md.getDriverName();
        int major = md.getDriverMajorVersion();
        int minor = md.getDriverMinorVersion();
        int index = name.indexOf(32);
        if (index != -1) {
            name = name.substring(0, index);
        }
        name = name.toLowerCase();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String packageName = this.getClass().getPackage().getName() + ".jdbc.";
        try {
            return classLoader.loadClass(packageName + name + "_" + major + "_" + minor + "_driver");
        }
        catch (ClassNotFoundException cnfe) {
            try {
                return classLoader.loadClass(packageName + name + "_" + major + "_driver");
            }
            catch (ClassNotFoundException cnfe2) {
                return classLoader.loadClass(packageName + name + "_driver");
            }
        }
    }

    protected boolean supressEntry(String name) {
        return true;
    }
}

